/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf;

import edu.neu.ccs.demeterf.control.Edge;
import edu.neu.ccs.demeterf.control.EdgeBypass;
import edu.neu.ccs.demeterf.control.EdgeOnly;
import edu.neu.ccs.demeterf.control.EdgeRemove;
import edu.neu.ccs.demeterf.control.Everywhere;
import edu.neu.ccs.demeterf.control.MutableControl;
import edu.neu.ccs.demeterf.control.Nowhere;
import edu.neu.ccs.demeterf.util.Util;
import java.util.HashSet;

public abstract class Control {
    protected HashSet<Class<?>> builtIns = new HashSet(32);

    public Control() {
        for (Class<?> c2 : Util.builtIns) {
            this.builtIns.add(c2);
        }
    }

    public static Control everywhere() {
        return new Everywhere();
    }

    public static Control nowhere() {
        return new Nowhere();
    }

    public static MutableControl builtins(Class<?> ... cls) {
        EdgeBypass ec = new EdgeBypass(new Edge[0]);
        Class<?>[] classArray = cls;
        int n2 = cls.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> c2 = classArray[n3];
            ((MutableControl)ec).addBuiltIn(c2);
            ++n3;
        }
        return ec;
    }

    public static MutableControl bypass(Edge ... edges) {
        return new EdgeBypass(edges);
    }

    public static MutableControl bypass(String s2) {
        return new EdgeBypass(s2);
    }

    public static MutableControl bypass(String pkg2, String s2) {
        return new EdgeBypass(pkg2, s2);
    }

    public static MutableControl bypass(Class<?> ... cs) {
        return new EdgeBypass(cs);
    }

    public static MutableControl only(Edge ... edges) {
        return new EdgeOnly(edges);
    }

    public static MutableControl only(String s2) {
        return new EdgeOnly(s2);
    }

    public static MutableControl only(String pkg2, String s2) {
        return new EdgeBypass(pkg2, s2);
    }

    public static MutableControl only(Class<?> ... cs) {
        return new EdgeOnly(cs);
    }

    public static MutableControl remove(Edge ... edges) {
        return new EdgeRemove(edges);
    }

    public static MutableControl remove(String s2) {
        return new EdgeRemove(s2);
    }

    public static MutableControl remove(String pkg2, String s2) {
        return new EdgeRemove(pkg2, s2);
    }

    public static MutableControl remove(Class<?> ... cs) {
        return new EdgeRemove(cs);
    }

    public abstract boolean skip(Class<?> var1, String var2);

    public abstract boolean skip(Edge var1);

    public abstract boolean ignore(Class<?> var1, String var2);

    public abstract boolean ignore(Edge var1);

    public boolean isBuiltInOld(Class<?> c2) {
        System.err.print("ISBUILT: " + c2.getName() + " = ");
        while (c2 != null) {
            if (this.builtIns.contains(c2)) {
                System.err.println("true");
                return true;
            }
            c2 = c2.getSuperclass();
        }
        System.err.println("false");
        return false;
    }

    public boolean isBuiltIn(Class<?> c2) {
        for (Class<?> b : this.builtIns) {
            if (!b.isAssignableFrom(c2)) continue;
            return true;
        }
        return false;
    }
}

