/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeterf.examples;

import edu.neu.ccs.demeterf.ID;
import edu.neu.ccs.demeterf.Traversal;
import edu.neu.ccs.demeterf.lib.RBColor;
import edu.neu.ccs.demeterf.lib.RBLeaf;
import edu.neu.ccs.demeterf.lib.RBNode;
import edu.neu.ccs.demeterf.lib.RBTree;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class RBTest {
    public static void main(String[] args2) {
        new Frame();
    }

    static class Frame
    extends JFrame {
        Frame() {
            super("Tree Test: Hit some keys!!");
            this.setSize(400, 300);
            this.setLocation(50, 50);
            this.setDefaultCloseOperation(3);
            TC tc = new TC();
            this.getContentPane().add(tc);
            this.addKeyListener(tc);
            this.setVisible(true);
        }

        static class TC
        extends JComponent
        implements KeyListener {
            RBTree<Integer> tree = RBTree.create((Comparable[])new Integer[0]);

            TC() {
            }

            @Override
            public void paint(Graphics g) {
                new Traversal(new Painter(g)).traverse(this.tree, new Painter.Trip(30, 10, this.getWidth()));
            }

            @Override
            public void keyPressed(KeyEvent ke) {
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }

            @Override
            public void keyTyped(KeyEvent ke) {
                char c2 = ke.getKeyChar();
                this.tree = !ke.isAltDown() ? this.tree.insert(Integer.valueOf(c2)) : this.tree.remove(Integer.valueOf(c2));
                this.repaint();
            }
        }
    }

    static class Painter
    extends ID {
        Graphics g;

        Painter(Graphics gg) {
            this.g = gg;
        }

        Trip update(RBNode n2, RBNode.left f, Trip t) {
            return new Trip(t.h + 60, t.l, t.mid());
        }

        Trip update(RBNode n2, RBNode.right f, Trip t) {
            return new Trip(t.h + 60, t.mid(), t.r);
        }

        int combine(RBNode n2, Color c2, int i, int l2, int r2, Trip p) {
            this.g.setColor(c2);
            this.g.fillOval(p.mid() - 15, p.h, 30, 30);
            String s2 = "" + (char)i;
            this.g.setColor(Color.white);
            this.g.drawChars(s2.toCharArray(), 0, s2.length(), p.mid() - 4 * s2.length(), p.h + 20);
            return 0;
        }

        int combine(RBLeaf<Integer> n2, Trip p) {
            this.g.setColor(Color.black);
            this.g.fillOval(p.mid(), p.h, 5, 5);
            return 0;
        }

        Color combine(RBColor c2) {
            return c2.isBlack() ? Color.black : Color.red;
        }

        public static class Trip {
            int h;
            int l;
            int r;

            Trip(int hh, int ll, int rr) {
                this.h = hh;
                this.l = ll;
                this.r = rr;
            }

            int mid() {
                return (this.l + this.r) / 2;
            }
        }
    }
}

