/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class MergeSort {
    static void p(String s2) {
        System.out.println(s2);
    }

    public static void main(String[] s2) {
        int len = s2.length > 0 ? Integer.parseInt(s2[0]) : 2000;
        L<Integer> l2 = MergeSort.rand(new id(), len);
        MergeSort.p(" Length = " + len);
        MergeSort.p("  Sort: " + new Sorter<Integer>().timesort(l2));
        MergeSort.p(" PSort: " + new PSorter<Integer>().timesort(l2));
        MergeSort.p(" ASort: " + new ASorter().timesort(l2, new Integer[len]));
    }

    static <D extends Comparable<D>> L<D> make(D ... xs) {
        return MergeSort.make(xs, (int)0, (int)xs.length);
    }

    static <D extends Comparable<D>> L<D> make(D[] xs, int i, int len) {
        return i == len ? new L() : MergeSort.make(xs, (int)(i + 1), (int)len).push(xs[i]);
    }

    static <D extends Comparable<D>> L<D> make(Creator<D> c2, int ... xs) {
        return MergeSort.make(c2, xs, xs.length - 1);
    }

    static <D extends Comparable<D>> L<D> make(Creator<D> c2, int[] xs, int i) {
        return i < 0 ? new L() : MergeSort.make(c2, xs, i - 1).push((Comparable)c2.make(xs[i]));
    }

    static int randInt() {
        return (int)(Math.random() * 20.0);
    }

    static <D extends Comparable<D>> L<D> rand(Creator<D> c2, int k) {
        return k == 0 ? new L() : MergeSort.rand(c2, k - 1).push((Comparable)c2.make(MergeSort.randInt()));
    }

    static <D extends Comparable<D>> L<D> merge(L<D> l1, L<D> l2) {
        if (l1.isEmpty()) {
            return l2;
        }
        if (l2.isEmpty()) {
            return l1;
        }
        if (l1.first().compareTo(l2.first()) <= 0) {
            return MergeSort.merge(l1.rest(), l2).push(l1.first());
        }
        return MergeSort.merge(l1, l2.rest()).push(l2.first());
    }

    static class ASorter<D extends Comparable<D>>
    extends Sorter<D> {
        ASorter() {
        }

        public Sorter.T timesort(L<D> l2, D[] a) {
            a = l2.toArray((Comparable[])a);
            System.gc();
            Thread.yield();
            long tm = System.currentTimeMillis();
            Arrays.sort(a);
            return new Sorter.T(System.currentTimeMillis() - tm, MergeSort.make((Comparable[])a));
        }
    }

    static class C<D extends Comparable<D>>
    extends L<D> {
        D f;
        L<D> r;

        C(D ff, L<D> rr) {
            this.f = ff;
            this.r = rr;
        }

        @Override
        boolean isEmpty() {
            return false;
        }

        @Override
        D first() {
            return this.f;
        }

        @Override
        L<D> rest() {
            return this.r;
        }

        @Override
        int length() {
            return 1 + this.r.length();
        }

        @Override
        L<D> reverse(L<D> ac) {
            return this.r.reverse(ac.push(this.f));
        }

        @Override
        L<D> append(L<D> l2) {
            return this.r.append(l2).push(this.f);
        }

        @Override
        L.P<D> split(int k, L<D> ac) {
            return k == 0 ? new L.P<D>(ac.reverse(), this) : this.r.split(k - 1, ac.push(this.f));
        }

        @Override
        public String toString() {
            return this.f + " " + this.r;
        }

        @Override
        D[] toArray(D[] d2, int i) {
            d2[i] = this.f;
            return this.r.toArray((Comparable[])d2, i + 1);
        }
    }

    static abstract class Creator<D> {
        Creator() {
        }

        abstract D make(int var1);
    }

    static class L<D extends Comparable<D>> {
        L() {
        }

        boolean isEmpty() {
            return true;
        }

        D first() {
            throw new RuntimeException("L.first() Bad");
        }

        L<D> rest() {
            throw new RuntimeException("L.rest() Bad");
        }

        int length() {
            return 0;
        }

        L<D> reverse() {
            return this.reverse(new L<D>());
        }

        L<D> reverse(L<D> ac) {
            return ac;
        }

        L<D> push(D d2) {
            return new C<D>(d2, this);
        }

        L<D> append(L<D> l2) {
            return l2;
        }

        P<D> split(int k) {
            return this.split(k, new L<D>());
        }

        P<D> split(int k, L<D> ac) {
            throw new RuntimeException("L.split() Bad");
        }

        public String toString() {
            return "";
        }

        D[] toArray(D[] d2) {
            return this.toArray((Comparable[])d2, 0);
        }

        D[] toArray(D[] d2, int i) {
            return d2;
        }

        static class P<D extends Comparable<D>> {
            L<D> lt;
            L<D> rt;

            P(L<D> l2, L<D> r2) {
                this.lt = l2;
                this.rt = r2;
            }

            public String toString() {
                return "<" + this.lt + " :: " + this.rt + ">";
            }
        }
    }

    static class PSorter<D extends Comparable<D>>
    extends Sorter<D> {
        PSorter() {
        }

        @Override
        public L<D> sort(L<D> l2) {
            int len = l2.length();
            if (len <= 1) {
                return l2;
            }
            L.P<D> p = l2.split(len / 2);
            Thrd lt = new Thrd(p.lt);
            lt.start();
            L rt = this.recsort(p.rt);
            p = null;
            lt.waitFor();
            return MergeSort.merge(lt.res, rt);
        }

        class Thrd
        extends Thread {
            L<D> lst;
            L<D> res;
            boolean fin = false;

            Thrd(L<D> l2) {
                this.lst = l2;
                this.res = null;
            }

            @Override
            public void run() {
                this.res = PSorter.this.recsort(this.lst);
                this.done();
            }

            synchronized void done() {
                this.fin = true;
                this.notifyAll();
            }

            synchronized void waitFor() {
                try {
                    while (!this.fin) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static class Sorter<D extends Comparable<D>> {
        Sorter() {
        }

        public L<D> sort(L<D> l2) {
            return this.recsort(l2);
        }

        public L<D> recsort(L<D> l2) {
            int len = l2.length();
            if (len <= 1) {
                return l2;
            }
            L.P<D> p = l2.split(len / 2);
            return MergeSort.merge(this.recsort(p.lt), this.recsort(p.rt));
        }

        public T timesort(L<D> l2) {
            System.gc();
            Thread.yield();
            long tm = System.currentTimeMillis();
            L<D> r2 = this.sort(l2);
            return new T(System.currentTimeMillis() - tm, r2);
        }

        class T {
            long mil;
            L<D> lst;

            T(long m, L<D> l2) {
                this.mil = m;
                this.lst = l2;
            }

            public String toString() {
                return " MSec: " + this.mil;
            }
        }
    }

    static class id
    extends Creator<Integer> {
        id() {
        }

        @Override
        Integer make(int i) {
            return i;
        }
    }
}

