package player.playeragent;

import static org.junit.Assert.*;
import edu.neu.ccs.demeterf.demfgen.lib.*;
import gen.*;

import org.junit.Test;


public class DeliverAgentTest {

    @Test 
    public void deliverRawMaterialR5() {
    	DeliverAgent agent = new DeliverAgent();
    	List<TypeInstance> typeInst = List.<TypeInstance>create(new TypeInstance(new RelationNr(5)));
    	
    	Derivative initialDeriv = new Derivative("D1", new PlayerID(0), Option.some(new PlayerID(1)), 
    			new Price(1), new Type(typeInst), Option.<RawMaterial>none(), Option.<FinishedProduct>none());
    	
    	Derivative result = agent.deliverRawMaterial(initialDeriv);
    	
    	assertTrue("Raw material in result Derivative", result.optraw.isSome());
    	
    	RawMaterial expected;
		try {
			// Currently, a fixed raw material is returned
			expected = RawMaterial.parse("rm[1: 5 v1 v2 v3  " +
											"1: 5 v1 v2 v4  " +
											"1: 5 v1 v2 v5  " +
											"1: 5 v1 v3 v4  " +
											"1: 5 v1 v3 v5  " +
											"1: 5 v1 v4 v5  " +
											"1: 5 v2 v3 v4  " +
											"1: 5 v2 v3 v5  " +
											"1: 5 v2 v4 v5  " +
											"1: 5 v3 v4 v5  ]");
		} catch (ParseException e) {
			e.printStackTrace();
			fail(e.getMessage());
			return;
		}
    	
		// Check that the resulting Derivative's raw material matches the expected one
    	assertTrue(result.optraw.inner().equals(expected));
    	
    	System.out.println(result.print());
    }

}
