package player.rawmaterialsolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import edu.neu.ccs.satsolver.PairI;
import gen.RelationNr;
import gen.Weight;

/**
 * Utility class for building creating instances of {@link InputInitialI} and
 * {@link InputUpdateI}.  Aggregates additions for the same relation numbers
 * to create one pair for each relation when buildSet is called.
 */
public class PairSetBuilder {
  
  private final boolean runningTotal;
  private double totalWeight;
  private final Map<Integer, Integer> map;
  
  /**
   * Takes the fraction out of the only the weights added to this,
   * good for creating an {@link InputInitialI}.
   */
  PairSetBuilder() {
    map = new HashMap<Integer, Integer>();
    runningTotal = true;
  }
  
  /**
   * Takes the fraction out of the only the given total weight,
   * good for creating an {@link InputUpdateI}.
   */
  PairSetBuilder(double totalWeight) {
    map = new HashMap<Integer, Integer>();
    this.totalWeight = totalWeight;
    runningTotal = false;
  }
  
  public void add(RelationNr r, Weight w) {
    Integer current = map.get(r.v);
    if (current == null) {
      map.put(r.v, w.v);
    } else {
      map.put(r.v, w.v + current);
    }
    if (runningTotal) {
      totalWeight += w.v;
    }
  }
  
  public Set<PairI> buildSet() {
    Set<PairI> result = new HashSet<PairI>();
    for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
      result.add(new Pair(entry.getKey(), ((double) entry.getValue())/totalWeight));
    }
    return result;
  }

}
