
package player.rawmaterialsolver;

import edu.neu.ccs.satsolver.InputInitialI;
import edu.neu.ccs.satsolver.PairI;
import gen.RelationNr;
import gen.Weight;

import java.util.Set;

/**
 * An implementation of {@link InputInitialI} used in 
 * {@link RawMaterialSolverState} for the initial state with no variables set
 */
public class InputInitial implements InputInitialI {
  
  private final PairSetBuilder builder = new PairSetBuilder();
  
  public void addConstraint(RelationNr r, Weight w) {
    builder.add(r, w);
  }
  
  public Set<PairI> getPairs() {
    return builder.buildSet();
  }
}