package edu.neu.ccs.csu670.components.cspsolver;

import edu.neu.ccs.satsolver.OutputI;
import gen.Assignment;
import gen.Sign;
import gen.Variable;

/**
 * Allows easy navigation through the possible assignments in a CSP.
 * 
 * @author David Halperin (halperin.dr@gmail.com)
 */
public interface CspSolverState {

  /**
   * @param variable Must be one of the variables returned by
   * {@link #getUnassignedVariables()}
   * 
   * @return a state based on the current state where each 
   * constraint containing variable in this state is reduced
   * and the literal for the variable and sign has been added
   * to the assignment.
   */
  public CspSolverState setVariable(Variable variable, Sign sign);
  
  /**
   * @return All variables which appear in a constraint and not in
   * the result of {@link #getAssignment()}.
   */
  public Iterable<Variable> getUnassignedVariables();
  
  /**
   * @return An assignment including all variables that were included
   * in the orignal problem, but are not in {@link #getUnassignedVariables()}.
   * All calls to {@link setVariable} on states leading to this one must
   * be represented with a literal of a corresponding variable and sign.
   */
  public Assignment getAssignment();
  
  /**
   * @return the percentage of constraints which have been
   * satisfied by the current assignment.
   */
  public double fractionSatisfied();
  
  /**
   * @return the percentage of constraints which are unsatisfiable 
   * by the current assignment.
   */
  public double fractionUnsatisfied();
  
  /**
   * @throws UnsupportedOperationException if this implementation doesn't 
   * keep track of the look ahead.
   */
  public OutputI getLookAhead();
}
