class A {
  private X x = null;
  private C c = null;
  private D d = null;
  
  public A(X x, C c1) {
  	this.x = x;
  	this.c = c1;
  }

  public A(X x, C c1, D d) {
  	this.x = x;
  	this.c = c1;
  	this.d = d;
  }

  public void set_x(X x) {
  	this.x = x;
  }
  
  public void set_c(C c) {
  	this.c = c;
  }
  
  public void set_d(D d) {
  	this.d = d;
  }
  
  public X get_x() {
  	return x;
  }
  
  public C get_c() {
  	return c;
  }
  
  public D get_d() {
  	return d;
  }
  
  public void print() {
  	traverse(new PrintVisitor(true));
  }
  
  public void display() {
  	traverse(new DisplayVisitor());
  }
  
  public int countG() {
  	CountVisitor cv = new CountVisitor();
  	traverse(cv);
  	return cv.getReturnValue();
  }
  
  protected void traverse(Visitor v) {
  	v.before(this);
  	
  	v.before_x(this, x);
  	x.traverse(v);
  	v.after_x(this, x);
  	
  	v.before_c(this, c);
  	c.traverse(v);
  	v.after_c(this, c);
  	
  	if (null != d) {
  	  v.before_d(this, d);
  	  d.traverse(v);
  	  v.after_d(this, d);
  	}
  	
  	v.after(this);
  }
  
}
