/**
 * Code by Daniel Rinehart <danielr@neophi.com>
 * Created for CSG260 Fall 2006 with Karl Lieberherr
 */
package edu.neu.ccs.satsolver;

import junit.framework.TestCase;
import edu.neu.ccs.satsolver.util.Polynomial;

public class SATSolverUtilTest extends TestCase {

	public void testCalculate() {
		MockInputInitial mockInputInitial = new MockInputInitial();
		mockInputInitial.addPair(new MockPair(22, 0.5));
		mockInputInitial.addPair(new MockPair(254, 0.5));

		OutputI baseOutput = SATSolverUtil.calculateBias(mockInputInitial);

		assertEquals(0.5, baseOutput.getMaxBias(), Polynomial.DELTA);

		PolynomialI polynomial = baseOutput.getPolynomial();
		assertEquals(2.0, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-4.5, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(3.0, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.0, polynomial.getCoefficient(0), Polynomial.DELTA);
	}

	public void testOperations() {
		MockInputInitial mockInputInitial = new MockInputInitial();
		mockInputInitial.addPair(new MockPair(22, 1.0));

		OutputI baseOutput = SATSolverUtil.calculateBias(mockInputInitial);

		assertEquals(1.0 / 3.0, baseOutput.getMaxBias(), Polynomial.DELTA);

		PolynomialI polynomial = baseOutput.getPolynomial();
		assertEquals(3.0, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-6.0, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(3.0, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.0, polynomial.getCoefficient(0), Polynomial.DELTA);

		// set 1 to false
		MockInputUpdate mockInputUpdate = new MockInputUpdate(baseOutput.getPolynomial());
		mockInputUpdate.addPair(new MockPair(102, 0.75), true);
		mockInputUpdate.addPair(new MockPair(22, 0.75), false);

		OutputI updatedOutput = SATSolverUtil.updateBias(mockInputUpdate);

		assertEquals((6.0 - Math.sqrt(15.75)) / 4.5, updatedOutput.getMaxBias(), Polynomial.DELTA);

		polynomial = updatedOutput.getPolynomial();
		assertEquals(0.75, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-3.0, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(2.25, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.0, polynomial.getCoefficient(0), Polynomial.DELTA);

		// set 1 to true
		mockInputUpdate = new MockInputUpdate(baseOutput.getPolynomial());
		mockInputUpdate.addPair(new MockPair(17, 0.75), true);
		mockInputUpdate.addPair(new MockPair(22, 0.75), false);

		updatedOutput = SATSolverUtil.updateBias(mockInputUpdate);

		assertEquals(0.0, updatedOutput.getMaxBias(), Polynomial.DELTA);

		polynomial = updatedOutput.getPolynomial();
		assertEquals(0.75, polynomial.getCoefficient(3), Polynomial.DELTA);
		assertEquals(-0.75, polynomial.getCoefficient(2), Polynomial.DELTA);
		assertEquals(-0.75, polynomial.getCoefficient(1), Polynomial.DELTA);
		assertEquals(0.75, polynomial.getCoefficient(0), Polynomial.DELTA);
	}

	public void testBadInput() {
		// bad realtion
		try {
			MockInputInitial mockInputInitial = new MockInputInitial();
			mockInputInitial.addPair(new MockPair(-22, 1.0));

			SATSolverUtil.calculateBias(mockInputInitial);

			fail("No error.");
		} catch (IllegalArgumentException error) {

		}

		try {
			MockInputInitial mockInputInitial = new MockInputInitial();
			mockInputInitial.addPair(new MockPair(422, 1.0));

			SATSolverUtil.calculateBias(mockInputInitial);

			fail("No error.");
		} catch (IllegalArgumentException error) {

		}

		// bad fraction
		try {
			MockInputInitial mockInputInitial = new MockInputInitial();
			mockInputInitial.addPair(new MockPair(22, -0.5));

			SATSolverUtil.calculateBias(mockInputInitial);

			fail("No error.");
		} catch (IllegalArgumentException error) {

		}

		try {
			MockInputInitial mockInputInitial = new MockInputInitial();
			mockInputInitial.addPair(new MockPair(22, 1.5));

			SATSolverUtil.calculateBias(mockInputInitial);

			fail("No error.");
		} catch (IllegalArgumentException error) {

		}

		// bad sum
		try {
			MockInputInitial mockInputInitial = new MockInputInitial();
			mockInputInitial.addPair(new MockPair(22, 0.5));

			SATSolverUtil.calculateBias(mockInputInitial);

			fail("No error.");
		} catch (IllegalArgumentException error) {

		}

		// bad difference
		try {
			MockInputUpdate mockInputUpdate = new MockInputUpdate(new MockPolynomial(new double[] {
					3, 2, 1, 0 }));
			mockInputUpdate.addPair(new MockPair(22, 0.5), true);
			mockInputUpdate.addPair(new MockPair(22, 0.75), false);

			SATSolverUtil.updateBias(mockInputUpdate);

			fail("No error.");
		} catch (IllegalArgumentException error) {

		}
	}
}
