package edu.neu.ccs.satsolver;

import java.util.Set;

/**
 * The first input from the csu team in the first call to
 * the outsourcing team code will be an InputInitialI class
 * instance.  This has the complete set of relation number/fraction
 * pairs that's required for computations.
 * <p>
 * All future calls will use the InputUpdateI interface.
 */
public interface InputInitialI {
  /**
   * Returns the set of all relation number/fraction pairs for
   * the formula we're working on.
   * <p>
   * No two pairs in the set should have the same relation number.
   *
   * @return a set of PairI instances
   */
  public Set getPairs();
}
