/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.satsolver.util;

import edu.neu.ccs.satsolver.PolynomialI;

public class Polynomial
implements PolynomialI {
    public static final double DELTA = Math.pow(10.0, -8.0);
    private double[] coefficients = new double[4];

    public Polynomial(double d, double d2, double d3, double d4) {
        this.coefficients[3] = d;
        this.coefficients[2] = d2;
        this.coefficients[1] = d3;
        this.coefficients[0] = d4;
    }

    private Polynomial() {
    }

    public Polynomial multiply(double d) {
        Polynomial polynomial = new Polynomial();
        for (int i = 0; i < this.coefficients.length; ++i) {
            polynomial.coefficients[i] = this.coefficients[i] * d;
        }
        return polynomial;
    }

    public Polynomial add(Polynomial polynomial) {
        Polynomial polynomial2 = new Polynomial();
        for (int i = 0; i < this.coefficients.length; ++i) {
            polynomial2.coefficients[i] = this.coefficients[i] + polynomial.coefficients[i];
        }
        return polynomial2;
    }

    public Polynomial subtract(Polynomial polynomial) {
        Polynomial polynomial2 = new Polynomial();
        for (int i = 0; i < this.coefficients.length; ++i) {
            polynomial2.coefficients[i] = this.coefficients[i] - polynomial.coefficients[i];
        }
        return polynomial2;
    }

    public Polynomial differentiate() {
        Polynomial polynomial = new Polynomial();
        polynomial.coefficients[2] = this.coefficients[3] * 3.0;
        polynomial.coefficients[1] = this.coefficients[2] * 2.0;
        polynomial.coefficients[0] = this.coefficients[1];
        return polynomial;
    }

    public double getCoefficient(int n) {
        return this.coefficients[n];
    }

    public int degree() {
        for (int i = 3; i > 0; --i) {
            if (Polynomial.equal(0.0, this.coefficients[i])) continue;
            return i;
        }
        return 0;
    }

    public double[] solve0() {
        int n = this.degree();
        if (n == 3 || n == 0) {
            throw new UnsupportedOperationException("Can't solve degree " + n + ".");
        }
        if (n == 2) {
            double d = this.coefficients[1] * this.coefficients[1] - 4.0 * this.coefficients[2] * this.coefficients[0];
            if (d < 0.0) {
                return new double[0];
            }
            double d2 = (-this.coefficients[1] + Math.sqrt(d)) / (2.0 * this.coefficients[2]);
            double d3 = (-this.coefficients[1] - Math.sqrt(d)) / (2.0 * this.coefficients[2]);
            return new double[]{d2, d3};
        }
        return new double[]{-this.coefficients[0] / this.coefficients[1]};
    }

    public double eval(double d) {
        double d2 = 0.0;
        for (int i = this.coefficients.length - 1; i > 0; --i) {
            d2 += this.coefficients[i];
            d2 *= d;
        }
        return d2 += this.coefficients[0];
    }

    public double maxX0To1() {
        double[] dArray;
        double d = 0.0;
        double d2 = this.eval(0.0);
        double d3 = this.eval(1.0);
        if (d3 > d2) {
            d = 1.0;
            d2 = d3;
        }
        if (this.degree() > 1 && (dArray = this.differentiate().solve0()).length > 0) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > 0.0) || !(dArray[i] < 1.0) || !((d3 = this.eval(dArray[i])) > d2)) continue;
                d = dArray[i];
                d2 = d3;
            }
        }
        return d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            if (Polynomial.equal(0.0, this.coefficients[i])) continue;
            if (stringBuffer.length() > 0 && this.coefficients[i] > 0.0) {
                stringBuffer.append("+");
            }
            if (i > 0 && Polynomial.equal(-1.0, this.coefficients[i])) {
                stringBuffer.append("-");
            } else if (i == 0 || !Polynomial.equal(1.0, this.coefficients[i])) {
                stringBuffer.append(this.coefficients[i]);
            }
            if (i <= 0) continue;
            stringBuffer.append("x");
            if (i <= 1) continue;
            stringBuffer.append("^");
            stringBuffer.append(i);
        }
        return stringBuffer.toString();
    }

    public static boolean equal(double d, double d2) {
        return Math.abs(d - d2) <= DELTA;
    }
}

