/**
 * Code by Daniel Rinehart <danielr@neophi.com>
 * Created for CSG260 Fall 2006 with Karl Lieberherr
 */
package edu.neu.ccs.satsolver;

import java.util.HashSet;
import java.util.Set;

public class MockInputUpdate implements InputUpdateI {
	private PolynomialI polynomial;

	private Set added = new HashSet();

	private Set subtracted = new HashSet();

	public void addPair(PairI pair, boolean add) {
		if (add) {
			added.add(pair);
		} else {
			subtracted.add(pair);
		}
	}

	public MockInputUpdate(PolynomialI polynomial) {
		this.polynomial = polynomial;
	}

	public Set getAddedPairs() {
		return added;
	}

	public PolynomialI getPolynomialBefore() {
		return polynomial;
	}

	public Set getSubtractedPairs() {
		return subtracted;
	}
}
