package csu670.editors.scanners.rules;

import org.eclipse.jface.text.rules.WordRule;

import csu670.editors.Config;


/**
 * An IRule that will detect keywords.
 *   
 * @author Pok
 */
public class KeywordRule extends WordRule {
	
	/**
	 * Create a rule that will detect keywords.  Keywords 
	 * must only contain alpha numeric characters only.  
	 *   
	 * @param keywords a list of keywords to detect.
	 */
	public KeywordRule(String[] keywords) {
		super(new KeywordDetector());
		for (int i=0; i<keywords.length; i++) {
			addWord(keywords[i], Config.KEYWORD_ITOKEN);
		}
	}
	
}