package csu670.editors.scanners;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;

import csu670.editors.scanners.rules.KeywordRule;
import csu670.editors.scanners.rules.TokenRule;


/**
 * Rule base scanner to highlight syntax.
 * @author Pok
 *
 */
public class XAspectScanner extends RuleBasedScanner {

	/**
	 * Keywords that will be detected with this scanner.
	 */
	public static final String[] keywords = new String[] {
		"aspect"
	};
	
	/**
	 * Tokens that will be detected with this scanner.
	 */
	public static final String[] tokens = new String[] {
		"//", "(", ")"
	};
	
	
	/**
	 * Default constructor, will set up rules automaticly.
	 */
	public XAspectScanner() {
		IRule[] rules = new IRule[2];
		rules[0] = new KeywordRule(keywords);
		rules[1] = new TokenRule(tokens);
		setRules(rules);
	}
	
	
	
}
