package csu670.editors.scanners;
import csu670.editors.*;
import csu670.editors.scanners.rules.KeywordRule;
import csu670.editors.scanners.rules.TokenRule;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;


/**
 * Rule base scanner to highlight syntax in the class dictionary partition.
 * 
 * @author Pok
 */
public class ClassDictionaryScanner extends RuleBasedScanner {

	/**
	 * Keywords that will be highlighted.
	 */
	public static final String[] keywords = new String[] {
		"common"
	};
	
	/**
	 * Tokens that will be highlighted.
	 */
	public static final String[] tokens = new String[] {
		"=", ".", "~", "|", ":", "@", "*",
		"(", ")", 
		"[", "]", 
		"{", "}", 
		"<", ">", 
		
		
	};
	
	/**
	 * Default constructor, will set up rules automaticly.
	 */
	public ClassDictionaryScanner() {

		IRule[] rules = new IRule[3];
		
		rules[0] = new SingleLineRule("\"", "\"", Config.STRING_ITOKEN, '\\');
		rules[1] = new KeywordRule(keywords);
		rules[2] = new TokenRule(tokens);
		
		
		setRules(rules);
	}
	
	
	
}
