package csu670.editors;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;


/**
 * Centralize class to hold all the config data.  
 * 
 * @author Pok
 *
 */
public class Config {
	
	/**
	 * Specify a temp dir to put generated files.
	 */
	public static final String TEMP_DIR = "temp";
	
	/**
	 * The demeterj executable to use.
	 */
	public static final String DEMTERJ_EXE = "demeterj.bat";
	
	/**
	 * IToken for default tokens.
	 */
	public static final IToken DEFAULT_ITOKEN = 
		new Token(
			new TextAttribute(
				new Color(Display.getCurrent(), 0, 0, 0) ));
	
	/**
	 * IToken for keywords.
	 */
	public static final IToken KEYWORD_ITOKEN = 
		new Token(
			new TextAttribute(
				new Color(Display.getCurrent(), 255, 0, 0) ));
	/**
	 * IToken for strings
	 */
	public static final IToken STRING_ITOKEN = 
		new Token(
			new TextAttribute(
				new Color(Display.getCurrent(), 0, 0, 255) ));
	
	/**
	 * IToken for our tokens
	 */
	public static final IToken TOKEN_ITOKEN = 
		new Token(
			new TextAttribute(
				new Color(Display.getCurrent(), 255, 0, 0), 
				null, 
				1)); // 1 = bold

	

	
}