package csu670.actions.exceptions;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

import csu670.generated.ParseException;

public class ValidationException extends RuntimeException {
	public ValidationException() {
		super();
	}
	
	public ValidationException(String msg) {
		super(msg);
	}
	
	public ValidationException(String msg, Throwable t) {
		super(msg, t);
	}
	
	public ValidationException(Throwable t) {
		super(t);
	}
	
	
	/**
	 * Title text to display for this error
	 * @return the string title
	 */
	public String getTitleText() {
		return getClass().getSimpleName();
	}
	
	/**
	 * Text to display in the error dialog
	 * @return the string body.
	 */
	public String getBodyText(IDocument doc) {
		if (getMessage() == null || getMessage().length() == 0) {
			return getCause().getMessage();
		} else {
			return getMessage();
		}
	}
	
	
	
}
