package csu670.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;

import csu670.actions.exceptions.StrategyDeclarationException;
import csu670.actions.exceptions.ValidationException;
import csu670.editors.Config;
import csu670.generated.StrategyDeclaration;
import csu670.generated.XAspectDocument;
import csu670.generated.XPathContextNode;
import csu670.generated.XPathDeclaration;
import edu.neu.ccs.demeter.aplib.sg.Strategy;

public abstract class ValidatorBase {
	
	
	
	
	
	/**
	 * List the values of all declared as context node
	 * @param docObj
	 * @return
	 */
	protected String[] listContextNode(XAspectDocument docObj) {
		ArrayList list = new ArrayList();
		Enumeration en = docObj.get_trSection().get_body().elements();
		while (en.hasMoreElements()) {
			Object element = en.nextElement();
			if (element instanceof XPathContextNode) {
				XPathContextNode d = (XPathContextNode) element;
				String body = d.get_contextnodename().get_string();
				list.add(body);
			}
		}
		
		return (String[])list.toArray(new String[list.size()]);
	}
	
	/**
	 * List the values of all declared xpath expressions.
	 * @param docObj
	 * @return
	 */
	protected String[] listXPath(XAspectDocument docObj) {
		ArrayList list = new ArrayList();
		Enumeration en = docObj.get_trSection().get_body().elements();
		while (en.hasMoreElements()) {
			Object element = en.nextElement();
			if (element instanceof XPathDeclaration) {
				XPathDeclaration d = (XPathDeclaration) element;
				String body = d.get_body();
				list.add(body);
			}
		}
		
		return (String[])list.toArray(new String[list.size()]);
	}
	
	
	/**
	 * List the values of all declare strategy expressions
	 * @param docObj
	 * @return
	 */
	protected String[] listStrategies(XAspectDocument docObj) {
		ArrayList list = new ArrayList();
		Enumeration en = docObj.get_trSection().get_body().elements();
		while (en.hasMoreElements()) {
			Object element = en.nextElement();
			if (element instanceof StrategyDeclaration) {
				StrategyDeclaration d = (StrategyDeclaration) element;
				String body = d.get_body();
				list.add(body);
			}
		}
		
		return (String[])list.toArray(new String[list.size()]);
	}
	
	
	

}