package xAspectsEditor.editors;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.*;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

import xAspectsEditor.editors.xAspWhiteSpaceDetector;

public class xAspRuleScanner extends RuleBasedScanner {

	private static Color Key_Color =
		new Color(Display.getCurrent(), new RGB(200, 0, 0));
	private static Color Comment_Color =
		new Color(Display.getCurrent(), new RGB(0, 200, 0));
	private static Color Default_Color =
		new Color(Display.getCurrent(), new RGB(0, 0, 200));
	public static String[] keywords = {
		"aspect", "declare", "strategy", "bypassing",
		"XPath", "union", "except", "intersect",
		"from", "to", "through", "via",
		"->", "/+/", "/", "|", "context", "node"
	};
	public static String[] specialchars = {
		":", "=", ".", ";", "{", "}",
		"<", ">", "(", ")", ",", "\""
	};
	
	public xAspRuleScanner() {
		IToken keyToken = new Token(new TextAttribute(Key_Color));
		IToken commentToken = new Token(new TextAttribute(Comment_Color));
		IToken defaultToken = new Token(new TextAttribute(Default_Color));
		
		WordRule keyword = new WordRule(
				new IxAspWordDetector(),defaultToken);
		for(int i = 0; i < keywords.length; ++i){
			keyword.addWord(keywords[i], keyToken);
		}
		
		WordRule special = new WordRule(
				new IxAspSpecialDetector(),keyToken);
		for(int i = 0; i < specialchars.length; ++i){
			special.addWord(specialchars[i], keyToken);
		}
		
		IRule[] rules = new IRule[4];
		rules[0] = new WhitespaceRule(new xAspWhiteSpaceDetector());
		rules[1] = new EndOfLineRule("//", commentToken);
		rules[2] = special;
		rules[3] = keyword;
		
		
		setRules(rules);
	}
}
