package xAspectsEditor.cd;
import edu.neu.ccs.demeter.*;
public class DisplayVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent; }
  public void set_indent(int new_indent) { indent = new_indent; }
  public DisplayVisitor() { super(); }
  public DisplayVisitor(int indent) {
    super();
    set_indent(indent);
  }

    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    DisplayVisitor(java.io.PrintWriter out)     { set_out(out); }
    DisplayVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush(); }
  public void before(Main host) {
    out.print(": Main  (");
    indent++;
  }
  public void after(Main host) {
    out.print(" )");
    indent--;
  }
  public void before(XAspect host) {
    out.print(": XAspect  (");
    indent++;
  }
  public void after(XAspect host) {
    out.print(" )");
    indent--;
  }
  public void before_classDict(XAspect source, ClassDict dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classDict> ");
  }
  public void before_traversals(XAspect source, TraversalDict dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<traversals> ");
  }
  public void before(ClassDict host) {
    out.print(": ClassDict  (");
    indent++;
  }
  public void after(ClassDict host) {
    out.print(" )");
    indent--;
  }
  public void before_name(ClassDict source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before_classdef(ClassDict source, Text dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<classdef> ");
    out.print(" : Text");
    out.print(" {{" + source.get_classdef() + "}" + "}" + " ");
  }
  public void before(TraversalDict host) {
    out.print(": TraversalDict  (");
    indent++;
  }
  public void after(TraversalDict host) {
    out.print(" )");
    indent--;
  }
  public void before_name(TraversalDict source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before_contextNode(TraversalDict source, ContextNode dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<contextNode> ");
  }
  public void before_traversals(TraversalDict source, TraversalRef_NList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<traversals> ");
  }
  public void before(ContextNode host) {
    out.print(": ContextNode  (");
    indent++;
  }
  public void after(ContextNode host) {
    out.print(" )");
    indent--;
  }
  public void before_node(ContextNode source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<node> ");
  }
  public void before(TraversalRef host) {
    out.print(": TraversalRef  (");
    indent++;
  }
  public void after(TraversalRef host) {
    out.print(" )");
    indent--;
  }
  public void before_traversal(TraversalRef source, Traversal dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<traversal> ");
  }
  public void before(Strategy host) {
    out.print(": Strategy  (");
    indent++;
  }
  public void after(Strategy host) {
    out.print(" )");
    indent--;
  }
  public void before_name(Strategy source, TraversalName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before_stratexpression(Strategy source, StratExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<stratexpression> ");
  }
  public void before(StratExpression host) {
    out.print(": StratExpression  (");
    indent++;
  }
  public void after(StratExpression host) {
    out.print(" )");
    indent--;
  }
  public void before_stratexp(StratExpression source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<stratexp> ");
    out.print(" : String");
    out.print(" \"" + source.get_stratexp() + "\" ");
  }
  public void before(XPath host) {
    out.print(": XPath  (");
    indent++;
  }
  public void after(XPath host) {
    out.print(" )");
    indent--;
  }
  public void before_name(XPath source, TraversalName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before_xpath(XPath source, XPathExpression dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<xpath> ");
  }
  public void before(XPathExpression host) {
    out.print(": XPathExpression  (");
    indent++;
  }
  public void after(XPathExpression host) {
    out.print(" )");
    indent--;
  }
  public void before_xpathexp(XPathExpression source, String dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<xpathexp> ");
    out.print(" : String");
    out.print(" \"" + source.get_xpathexp() + "\" ");
  }
  public void before(XPathDef host) {
    out.print(": XPathDef  (");
    indent++;
  }
  public void after(XPathDef host) {
    out.print(" )");
    indent--;
  }
  public void before_xpathexp(XPathDef source, XPathExp dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<xpathexp> ");
  }
  public void before(CompactXPath host) {
    out.print(": CompactXPath  (");
    indent++;
  }
  public void after(CompactXPath host) {
    out.print(" )");
    indent--;
  }
  public void before_pathDir(CompactXPath source, PathDir dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<pathDir> ");
  }
  public void before_target(CompactXPath source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<target> ");
  }
  public void before_next(CompactXPath source, CompactXPath dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  public void before(Absolute host) {
    out.print(": Absolute  (");
    indent++;
  }
  public void after(Absolute host) {
    out.print(" )");
    indent--;
  }
  public void before(Relative host) {
    out.print(": Relative  (");
    indent++;
  }
  public void after(Relative host) {
    out.print(" )");
    indent--;
  }
  public void before(VerboseXPath host) {
    out.print(": VerboseXPath  (");
    indent++;
  }
  public void after(VerboseXPath host) {
    out.print(" )");
    indent--;
  }
  public void before_op(VerboseXPath source, Op dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<op> ");
  }
  public void before_arg1(VerboseXPath source, XPathRef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<arg1> ");
  }
  public void before_arg2(VerboseXPath source, XPathRef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<arg2> ");
  }
  public void before(Union host) {
    out.print(": Union  (");
    indent++;
  }
  public void after(Union host) {
    out.print(" )");
    indent--;
  }
  public void before(Except host) {
    out.print(": Except  (");
    indent++;
  }
  public void after(Except host) {
    out.print(" )");
    indent--;
  }
  public void before(Intersect host) {
    out.print(": Intersect  (");
    indent++;
  }
  public void after(Intersect host) {
    out.print(" )");
    indent--;
  }
  public void before(CXPathExp host) {
    out.print(": CXPathExp  (");
    indent++;
  }
  public void after(CXPathExp host) {
    out.print(" )");
    indent--;
  }
  public void before_compactxpath(CXPathExp source, CompactXPath dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<compactxpath> ");
  }
  public void before(Variable host) {
    out.print(": Variable  (");
    indent++;
  }
  public void after(Variable host) {
    out.print(" )");
    indent--;
  }
  public void before_name(Variable source, ClassName dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
  }
  public void before(ComplexXPathRef host) {
    out.print(": ComplexXPathRef  (");
    indent++;
  }
  public void after(ComplexXPathRef host) {
    out.print(" )");
    indent--;
  }
  public void before_verbosexpath(ComplexXPathRef source, VerboseXPath dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<verbosexpath> ");
  }
  public void before(TraversalName host) {
    out.print(": TraversalName  (");
    indent++;
  }
  public void after(TraversalName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(TraversalName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(ClassName host) {
    out.print(": ClassName  (");
    indent++;
  }
  public void after(ClassName host) {
    out.print(" )");
    indent--;
  }
  public void before_name(ClassName source, Ident dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<name> ");
    out.print(" : Ident");
    out.print(" \"" + source.get_name() + "\"");
  }
  public void before(PrintVisitor host) {
    out.print(": PrintVisitor  (");
    indent++;
  }
  public void after(PrintVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(PrintVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<needSpace> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(CopyVisitor host) {
    out.print(": CopyVisitor  (");
    indent++;
  }
  public void after(CopyVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_copy(CopyVisitor source, Object dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<copy> ");
  }
  public void before(SubgraphVisitor host) {
    out.print(": SubgraphVisitor  (");
    indent++;
  }
  public void after(SubgraphVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(EqualVisitor host) {
    out.print(": EqualVisitor  (");
    indent++;
  }
  public void after(EqualVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<is_equal> ");
    out.print(" : boolean \"" + dest + "\"");
  }
  public void before(DisplayVisitor host) {
    out.print(": DisplayVisitor  (");
    indent++;
  }
  public void after(DisplayVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(DisplayVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before(TraceVisitor host) {
    out.print(": TraceVisitor  (");
    indent++;
  }
  public void after(TraceVisitor host) {
    out.print(" )");
    indent--;
  }
  public void before_indent(TraceVisitor source, int dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<indent> ");
    out.print(" : int \"" + dest + "\"");
  }
  public void before(TraversalRef_NList host) {
    out.print(": TraversalRef_NList  {");
    indent++;
  }
  public void after(TraversalRef_NList host) {
    out.print(" }");
    indent--;
  }
  public void before_first(TraversalRef_NList source, Nonempty_TraversalRef_NList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<first> ");
  }
  public void before(Nonempty_TraversalRef_NList host) {
    out.print(": Nonempty_TraversalRef_NList  (");
    indent++;
  }
  public void after(Nonempty_TraversalRef_NList host) {
    out.print(" )");
    indent--;
  }
  public void before_it(Nonempty_TraversalRef_NList source, TraversalRef dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<it> ");
  }
  public void before_next(Nonempty_TraversalRef_NList source, Nonempty_TraversalRef_NList dest) {
    out.println();    for (int i = 0; i < indent; i++) out.print("\t");
    out.print("<next> ");
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
