package xAspectsEditor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.*;

import java.util.*;

import xAspectsEditor.editors.xAspDocumentProvider;
import xAspectsEditor.editors.xAspEditor;
import xAspectsEditor.cd.*;

import edu.neu.ccs.demeter.*;
import edu.neu.ccs.demeter.dj.*;
import edu.neu.ccs.demeter.aplib.cd.*;
import edu.neu.ccs.demeter.aplib.sg.*;
import edu.neu.ccs.demeter.dj.Visitor;
import edu.neu.ccs.demeter.aplib.Traversal;

public class xAspToolBarAction implements IWorkbenchWindowActionDelegate{
	private IWorkbenchWindow window;
	private static Color BG_Color =
		new Color(Display.getCurrent(), new RGB(255, 255, 255));
	private static Color Error_Color =
		new Color(Display.getCurrent(), new RGB(200, 0, 0));
	public Hashtable strategyList;
	public Hashtable sgStratList;
	public Hashtable xpathStratList;
	
	public xAspToolBarAction () {}

	public void run(IAction action) {
		strategyList = new Hashtable();
		sgStratList = new Hashtable();
		xpathStratList = new Hashtable();
		
		//save files
		IWorkbenchPage activePage = window.getActivePage();
		IEditorPart activeEditor = activePage.getActiveEditor();
		activePage.saveEditor(activeEditor, false);

		//extract document text
		xAspEditor xEditor = (xAspEditor)activeEditor;
		xAspDocumentProvider activeProvider = xEditor.getProvider();		
		IDocument activeDocument = activeProvider.getDocument();
		String doctext = activeDocument.get();

		try{
			////////////////////////////////
			// Syntax & Semantic Checking //
			////////////////////////////////
			
			// (Syntax) check input
			XAspect xasp = XAspectExt.parse(doctext, xEditor);
			if(xEditor.exceptionThrown()){
				displayError(xEditor);
			}
			else{
				edu.neu.ccs.demeter.dj.ClassGraph cgDJ = 
					xEditor.getClassGraph();	
				
				// (Syntax) check CD text
				Text cdBlock = (Text)cgDJ.fetch(xasp, 
						"from xAspectsEditor.cd.XAspect " +
		    				"via xAspectsEditor.cd.ClassDict " +
		    					"to edu.neu.ccs.demeter.Text");
				edu.neu.ccs.demeter.aplib.cd.ClassGraph cgAP =
					edu.neu.ccs.demeter.aplib.cd.ClassGraph.fromString(cdBlock.toString());
				cgAP = cgAP.normalize();
				
				// (Syntax) check strategies
				List strategies = cgDJ.gather(xasp, 
						"from xAspectsEditor.cd.XAspect to " +
							"xAspectsEditor.cd.Strategy");
				Iterator i = strategies.iterator();
				
				edu.neu.ccs.demeter.aplib.sg.Strategy sgStrat;
				String name, expr;
				Ident iName;
				
				xAspectsEditor.cd.Strategy cdStrat;
				xAspectsEditor.cd.TraversalName stratName;
				xAspectsEditor.cd.StratExpression stratExpr;
				while(i.hasNext()){
					cdStrat = (xAspectsEditor.cd.Strategy)i.next();
					stratExpr = cdStrat.get_stratexpression();
					expr = stratExpr.get_stratexp();
					sgStrat = edu.neu.ccs.demeter.aplib.sg.Strategy.fromString(expr);										
					stratName = cdStrat.get_name();
					iName = stratName.get_name();
					name = iName.toString();
					
					// (Semantic) check for strategy duplication
					if(strategyList.containsKey(name)){
						throw new Exception("Strategy <" + name + "> is already defined!");
					}
					else{
						strategyList.put(name, expr);
						sgStratList.put(name, sgStrat);
					}
				}
				
				// (Syntax) check XPath strategies
				List Xstrategies = cgDJ.gather(xasp, 
						"from xAspectsEditor.cd.XAspect " +
							"to xAspectsEditor.cd.XPath");
				i = Xstrategies.iterator();
				
				edu.neu.ccs.demeter.Ident icontextNode; 
				icontextNode = (edu.neu.ccs.demeter.Ident)cgDJ.fetch(xasp,
						"from xAspectsEditor.cd.XAspect " +
							"via xAspectsEditor.cd.ContextNode " +
								"to edu.neu.ccs.demeter.Ident");
				String contextNode = icontextNode.toString();
				
				List reflist;
				Iterator irefs;
				String srefname, start, end, currentstrat;
				edu.neu.ccs.demeter.Ident irefname;
				xAspectsEditor.cd.XPath cdXPath;
				xAspectsEditor.cd.XPathDef XPathStrat;
				xAspectsEditor.cd.XPathExpression XPathExpr;
				while(i.hasNext()){
					cdXPath = (xAspectsEditor.cd.XPath)i.next();
					XPathExpr = cdXPath.get_xpath();
					XPathStrat = xAspectsEditor.cd.XPathDef.parse(XPathExpr.get_xpathexp());
					expr = XPathStrat.Translate(contextNode);
					
					// (Semantic) check strategy references
					reflist = cgDJ.gather(XPathStrat,
							"from xAspectsEditor.cd.XPathDef " +
								"via xAspectsEditor.cd.Variable " +
									"to edu.neu.ccs.demeter.Ident");
					if(!reflist.isEmpty()){
						irefs = reflist.iterator();
						while(irefs.hasNext()){
							irefname = (edu.neu.ccs.demeter.Ident)irefs.next();
							srefname = irefname.toString();
							
							// (Semantic) check for illegal references
							if(!strategyList.containsKey(srefname)){
								throw new Exception("Strategy <" + srefname + "> does not exist!");
							}
							else{
								currentstrat = (String)strategyList.get(srefname);
								int refplace = expr.indexOf(srefname);
								while(refplace > 0){
									start = expr.substring(0, refplace);
									end = expr.substring(refplace+srefname.length());
									expr = start + currentstrat + end;
									refplace = expr.indexOf(srefname);
								}
							}
						}
					}
					sgStrat = edu.neu.ccs.demeter.aplib.sg.Strategy.fromString(expr);
					
					stratName = cdXPath.get_name();
					iName = stratName.get_name();
					name = iName.toString();
					
					// (Semantic) check xpath strategy duplication
					if(strategyList.containsKey(name)){
						throw new Exception("Strategy <" + name + "> is already defined!");
					}
					else{
						strategyList.put(name, expr);
						sgStratList.put(name, sgStrat);
						xpathStratList.put(name, XPathStrat);
					}
				}
				
				// (Semantic) check strategy Traversal paths
				Enumeration en = sgStratList.keys();
				while(en.hasMoreElements()){
					name = (String)en.nextElement();
					sgStrat = (edu.neu.ccs.demeter.aplib.sg.Strategy)sgStratList.get(name);
					Traversal.compute(sgStrat, cgAP);
				}
				
				// (Semantic) check ClassGraph node definitions
				ArrayList cgNodes = new ArrayList(cgAP.getNodes());
				Object obj;
				for(int j = 0; j < cgNodes.size(); j++){
					obj = cgNodes.get(j);
					if(!cgAP.definesClass(obj.toString())){
						throw new Exception("Type <" + obj.toString() + "> does not exist!");
					}
				}
				
				// (Semantic) check CD for class duplication
				LinkedList classList = new LinkedList();
				String cdString = cdBlock.toString();
				int equal, period;
				String classname;
				while(cdString.indexOf("=") > 0){
					cdString = cdString.trim();
					equal = cdString.indexOf("=");
					period = cdString.indexOf(".");
					classname = cdString.substring(0, equal);
					classname = classname.trim();
					if(classList.contains(classname)){
						throw new Exception("Type <" + classname +"> is already defined!");
					}
					classList.add(classname);
					cdString = cdString.substring(period+1);					
				}
				
				///////////////////////////////
				// CD Traversal Highlighting //
				///////////////////////////////
				xEditor.setView("Input successfully compiled...");
			}
		}
		catch(Error e){
			xEditor.addError(e.toString());
			displayError(xEditor);
			//e.printStackTrace();
		}
		catch(Exception e){
			xEditor.addError(e.toString());
			displayError(xEditor);
			//e.printStackTrace();
		}
		finally {
			xEditor.setErrorBuffer();
		}
				
	}
	
	public void displayError(xAspEditor xEditor){
		String err = xEditor.getErrorMsg();
		xEditor.setView(err);
		xEditor.setStyle(0, err.length(), Error_Color, BG_Color);
	}
	
	public void selectionChanged(IAction action, ISelection selection) {}

	public void dispose() {}

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}
