package xAspectsEditor.cd;
import edu.neu.ccs.demeter.*;
public class PrintVisitor extends UniversalVisitor {
  protected int indent;
  public int get_indent() { return indent; }
  public void set_indent(int new_indent) { indent = new_indent; }
  protected boolean needSpace;
  public boolean get_needSpace() { return needSpace; }
  public void set_needSpace(boolean new_needSpace) { needSpace = new_needSpace; }
  public PrintVisitor() { super(); }
  public PrintVisitor(int indent, boolean needSpace) {
    super();
    set_indent(indent);
    set_needSpace(needSpace);
  }

    protected java.io.PrintWriter out = new java.io.PrintWriter(System.out, true);
    java.io.PrintWriter get_out()             { return out; }
    void set_out(java.io.PrintWriter new_out) { out = new_out; }
    PrintVisitor(java.io.PrintWriter out)     { set_out(out); }
    PrintVisitor(java.io.PrintStream out)
      { set_out(new java.io.PrintWriter(out, true)); }
  
  public void finish() { out.flush(); }
  protected void space() {
    if (needSpace) out.print(" ");
    needSpace = false;
  }
  public void before_name(ClassDict source, ClassName dest) {
    space();
    out.print("aspect");
    needSpace = true;
    out.print("(");
    needSpace = false;
    space();
    out.print("ClassDictionary");
    needSpace = true;
    out.print(")");
    needSpace = false;
  }
  public void before_classdef(ClassDict source, Text dest) {
    space();
    out.print("{{" + source.get_classdef() + "}" + "}");
    needSpace = true;
  }
  public void before_name(TraversalDict source, ClassName dest) {
    space();
    out.print("aspect");
    needSpace = true;
    out.print("(");
    needSpace = false;
    space();
    out.print("Traversal");
    needSpace = true;
    out.print(")");
    needSpace = false;
  }
  public void before_contextNode(TraversalDict source, ContextNode dest) {
    out.print("{");
    needSpace = false;
  }
  public void after_traversals(TraversalDict source, TraversalRef_NList dest) {
    out.print("}");
    needSpace = false;
  }
  public void before_node(ContextNode source, ClassName dest) {
    space();
    out.print("XPath");
    needSpace = true;
    space();
    out.print("context");
    needSpace = true;
    space();
    out.print("node");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void after_node(ContextNode source, ClassName dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_traversal(TraversalRef source, Traversal dest) {
    space();
    out.print("declare");
    needSpace = true;
  }
  public void before_name(Strategy source, TraversalName dest) {
    space();
    out.print("strategy");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void before_stratexpression(Strategy source, StratExpression dest) {
    out.print(":");
    needSpace = false;
  }
  public void after_stratexpression(Strategy source, StratExpression dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_stratexp(StratExpression source, String dest) {
    space();
    out.print("\"" + source.get_stratexp() + "\"");
    needSpace = true;
  }
  public void before_name(XPath source, TraversalName dest) {
    space();
    out.print("XPath");
    needSpace = true;
    out.print(":");
    needSpace = false;
  }
  public void before_xpath(XPath source, XPathExpression dest) {
    out.print(":");
    needSpace = false;
  }
  public void after_xpath(XPath source, XPathExpression dest) {
    out.print(";");
    needSpace = false;
  }
  public void before_xpathexp(XPathExpression source, String dest) {
    space();
    out.print("\"" + source.get_xpathexp() + "\"");
    needSpace = true;
  }
  public void before(Absolute host) {
    out.print("/");
    needSpace = false;
  }
  public void before(Relative host) {
    out.print("/+/");
    needSpace = false;
  }
  public void before_arg1(VerboseXPath source, XPathRef dest) {
    out.print("(");
    needSpace = false;
  }
  public void before_arg2(VerboseXPath source, XPathRef dest) {
    out.print(",");
    needSpace = false;
  }
  public void after_arg2(VerboseXPath source, XPathRef dest) {
    out.print(")");
    needSpace = false;
  }
  public void before(Union host) {
    space();
    out.print("union");
    needSpace = true;
  }
  public void before(Except host) {
    space();
    out.print("except");
    needSpace = true;
  }
  public void before(Intersect host) {
    space();
    out.print("intersect");
    needSpace = true;
  }
  public void before_name(TraversalName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_name(ClassName source, Ident dest) {
    space();
    out.print(source.get_name());
    needSpace = true;
  }
  public void before_indent(PrintVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_needSpace(PrintVisitor source, boolean dest) {
    space();
    out.print(source.get_needSpace());
    needSpace = true;
  }
  public void before_copy(CopyVisitor source, Object dest) {
    space();
    out.print(source.get_copy());
    needSpace = true;
  }
  public void before_is_equal(SubgraphVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
  }
  public void before_is_equal(EqualVisitor source, boolean dest) {
    space();
    out.print(source.get_is_equal());
    needSpace = true;
  }
  public void before_indent(DisplayVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  public void before_indent(TraceVisitor source, int dest) {
    space();
    out.print(source.get_indent());
    needSpace = true;
  }
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
