package button_Test_New.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import MyEditor.editors.MyEditor;
import EclipsePlugin.helper.*;
import EclipsePlugin.helper2.*;
import edu.neu.ccs.demeter.aplib.cd.*;
import edu.neu.ccs.demeter.aplib.sg.*;
import edu.neu.ccs.demeter.aplib.*;
import java.util.*;
/**
 * Our sample action implements workbench action delegate.
 * The action proxy will be created by the workbench and
 * shown in the UI. When the user tries to use the action,
 * this delegate will be created and execution will be 
 * delegated to it.
 * @see IWorkbenchWindowActionDelegate
 */
public class SampleAction implements IWorkbenchWindowActionDelegate {
	
	private IWorkbenchWindow MyWindow;
	private XAspect MyAspect;
	private ClassGraph cg;
	private Strategy sg;
	private XPath MyXPathObject;
	/**
	 * The constructor.
	 */
	public SampleAction() {
	
	}
	
	/**
	 * The action has been activated. The argument of the
	 * method represents the 'real' action sitting
	 * in the workbench UI.
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		
		MyEditor temp = (MyEditor)MyWindow.getActivePage().getActiveEditor();
		temp.outputWindow.setText(SyntaxChecker(temp.getDocumentProvider().getDocument(temp.getEditorInput()).get()));
	
	}
	
	
	//Syntax Checking
	public String SyntaxChecker(String input){
		StringBuilder returnString = new StringBuilder();
		
		try{
			MyAspect = XAspect.createXAspect(input);
		}
		
		catch(Exception e){
			returnString.append(e.toString());
			return returnString.toString();
		}
		
		catch(Error e){
			returnString.append(e.toString());
			return returnString.toString();
		}
		
		returnString.append("Testing aspect syntax...passed.\n");
		String temp = MyAspect.getClassDictionary().toString();
		
		try{
			cg = ClassGraph.fromString(temp);
		}
		
		catch(Exception e){
			returnString.append(e.toString());
			return returnString.toString();
		}
		
		catch(Error e){
			returnString.append(e.toString());
			return returnString.toString();
		}
		
		returnString.append("Testing class dicitionary syntax...passed.\n");
		List<String> strategies = MyAspect.getStrategies();
		
		for(String x : strategies){
			try{
				sg = Strategy.fromString(x);
			}
			
			catch(Exception e){
				returnString.append(e.toString());
				return returnString.toString();
			}
			
			catch(Error e){
				returnString.append(e.toString());
				return returnString.toString();
			}
		}
		returnString.append("Testing strategy syntax...passed.\n");
		
		List<String> xpath = MyAspect.getXPath();
		for(String x : xpath){
			try{
				MyXPathObject = XPath.createXPath(x);
			}
			catch(Exception e){
				returnString.append(e.toString());
				return returnString.toString();
			}
			catch(Error e){
				returnString.append(e.toString());
				return returnString.toString();
			}
		}
		returnString.append("Testing XPath syntax...passed.\n");
		
		
		//Semantic checking
		Collection nodes = cg.getNodes();
		Collection outgoingEdges;
		Collection tempNodes = new ArrayList();
		for(Object o: nodes){
			try{
				outgoingEdges = cg.getOutgoingEdges(o);
				for (Object x : outgoingEdges){
					tempNodes.add(x);
					System.out.println(x);
				}
			}
			catch(NoSuchClassGraphNodeException e){
				System.out.println(e);
			}
		}
		
		boolean contains = false;
		for (Object o: tempNodes){
			for(Object o2 : nodes){
				if ((o.toString().replaceAll("<[a-zA-Z]*>","")).trim().contains(o2.toString().replaceAll("<[a-zA-Z]*>","").trim())){
					contains = true;
					break;
				}
				else
					contains = false;
			}
			if (contains == false){
				returnString.append(o.toString().replaceAll("<[a-zA-Z]*>","").trim() + " not defined");
				return returnString.toString();
			}
		}
		returnString.append("Testing Class Graph semantics...passed.\n");
		return returnString.toString();
		
	}
	
	/**
	 * Selection in the workbench has been changed. We 
	 * can change the state of the 'real' action here
	 * if we want, but this can only happen after 
	 * the delegate has been created.
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system
	 * resources we previously allocated.
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to
	 * be able to provide parent shell for the message dialog.
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.MyWindow = window;
	}
}