package MyEditor.editors;

import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;

import MyEditor.editors.GetText;

/**
 * Step 2
 * Add syntx coloring
 */
public class MyEditor extends TextEditor {

	public StyledText outputWindow;
	private Composite parent;
	private IWorkbenchWindow MyWindow;
	
	public Composite getParent(){
		return parent;
	}
	
	public MyEditor()
	{
		super();
		setSourceViewerConfiguration(new MySourceViewerConfig());
	}
	
	public String grabText()
	{
		
		String result = null;
		
		try{
			GetText EditorText = new GetText();
			IDocument NewDoc = EditorText.createDocument(MyWindow.getActivePage().getActiveEditor().getEditorInput());
			result = NewDoc.get();
		}
		catch(Exception e){
			System.out.println(e);
		}
		
		return result;
	}
	
	public String get_Text()
	{
		return this.outputWindow.getText();
	}
	
	public void createPartControl(Composite comp) {
		
		// initialize the window
		this.parent = comp;
		super.createPartControl(parent);

		//get any buffered errors

		// initialize the output window as a part of the editor window
		outputWindow = new StyledText(parent, 1);
		
		// add the output window to the editor window
		super.createPartControl(outputWindow);
		
		// put the output window under the editing window
		FillLayout layout = (FillLayout) parent.getLayout();
		
		layout.type = SWT.HORIZONTAL;
		
		parent.setLayout(layout);

		// highlight the selected class dictionary Here.
		
	}

}