/*
 * Decompiled with CFR 0.152.
 */
package EclipsePlugin.helper;

import EclipsePlugin.helper.Aspect;
import EclipsePlugin.helper.Body;
import EclipsePlugin.helper.ClassDicBody;
import EclipsePlugin.helper.ClassDicDef;
import EclipsePlugin.helper.ClassDicName;
import EclipsePlugin.helper.ContextName;
import EclipsePlugin.helper.CopyVisitor;
import EclipsePlugin.helper.Declaration;
import EclipsePlugin.helper.DisplayVisitor;
import EclipsePlugin.helper.EqualVisitor;
import EclipsePlugin.helper.Main;
import EclipsePlugin.helper.Strategy;
import EclipsePlugin.helper.StrategyBody;
import EclipsePlugin.helper.StrategyDeclaration;
import EclipsePlugin.helper.StrategyName;
import EclipsePlugin.helper.SubgraphVisitor;
import EclipsePlugin.helper.TraceVisitor;
import EclipsePlugin.helper.Traversal;
import EclipsePlugin.helper.TraversalBody;
import EclipsePlugin.helper.TraversalBodyList;
import EclipsePlugin.helper.TraversalDef;
import EclipsePlugin.helper.TraversalName;
import EclipsePlugin.helper.UniversalVisitor;
import EclipsePlugin.helper.XPath;
import EclipsePlugin.helper.XPathBody;
import EclipsePlugin.helper.XPathContextNode;
import EclipsePlugin.helper.XPathDeclaration;
import EclipsePlugin.helper.XPathName;
import edu.neu.ccs.demeter.Ident;
import edu.neu.ccs.demeter.Text;
import java.io.PrintStream;
import java.io.PrintWriter;

class PrintVisitor
extends UniversalVisitor {
    protected int indent;
    protected boolean needSpace;
    protected PrintWriter out = new PrintWriter(System.out, true);

    public int get_indent() {
        return this.indent;
    }

    public void set_indent(int n) {
        this.indent = n;
    }

    public boolean get_needSpace() {
        return this.needSpace;
    }

    public void set_needSpace(boolean bl) {
        this.needSpace = bl;
    }

    public PrintVisitor() {
    }

    public PrintVisitor(int n, boolean bl) {
        this.set_indent(n);
        this.set_needSpace(bl);
    }

    PrintWriter get_out() {
        return this.out;
    }

    void set_out(PrintWriter printWriter) {
        this.out = printWriter;
    }

    PrintVisitor(PrintWriter printWriter) {
        this.set_out(printWriter);
    }

    PrintVisitor(PrintStream printStream) {
        this.set_out(new PrintWriter(printStream, true));
    }

    public void finish() {
        this.out.flush();
    }

    protected void space() {
        if (this.needSpace) {
            this.out.print(" ");
        }
        this.needSpace = false;
    }

    public void before_declaration(Aspect aspect, Declaration declaration) {
        this.space();
        this.out.print("aspect");
        this.needSpace = true;
    }

    public void before_ClassDicName(ClassDicDef classDicDef, ClassDicName classDicName) {
        this.out.print("(ClassDictionary)");
        this.needSpace = false;
    }

    public void before_text(ClassDicBody classDicBody, Text text) {
        this.space();
        this.out.print("{{" + classDicBody.get_text() + "}" + "}");
        this.needSpace = true;
    }

    public void before_ident(ClassDicName classDicName, Ident ident) {
        this.space();
        this.out.print(classDicName.get_ident());
        this.needSpace = true;
    }

    public void before_xpathcontextnode(Traversal traversal, XPathContextNode xPathContextNode) {
        this.out.print("{");
        this.needSpace = false;
    }

    public void after_traversalbodylist(Traversal traversal, TraversalBodyList traversalBodyList) {
        this.out.print("}");
        this.needSpace = false;
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_contextname(XPathContextNode xPathContextNode, ContextName contextName) {
        this.space();
        this.out.print("XPath context node:");
        this.needSpace = false;
    }

    public void after_contextname(XPathContextNode xPathContextNode, ContextName contextName) {
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_contextName(ContextName contextName, String string) {
        this.space();
        this.out.print("\"" + contextName.get_contextName() + "\"");
        this.needSpace = true;
    }

    public void before_traversalname(TraversalDef traversalDef, TraversalName traversalName) {
        this.out.print("(Traversal)");
        this.needSpace = false;
    }

    public void before_ident(TraversalName traversalName, Ident ident) {
        this.space();
        this.out.print(traversalName.get_ident());
        this.needSpace = true;
    }

    public void before_body(TraversalBody traversalBody, Body body) {
        this.space();
        this.out.print("declare");
        this.needSpace = true;
    }

    public void after_strategybody(Strategy strategy, StrategyBody strategyBody) {
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_strategyname(StrategyDeclaration strategyDeclaration, StrategyName strategyName) {
        this.space();
        this.out.print("strategy:");
        this.needSpace = false;
    }

    public void after_strategyname(StrategyDeclaration strategyDeclaration, StrategyName strategyName) {
        this.out.print(":");
        this.needSpace = false;
    }

    public void before_ident(StrategyName strategyName, Ident ident) {
        this.space();
        this.out.print(strategyName.get_ident());
        this.needSpace = true;
    }

    public void before_strategyBody(StrategyBody strategyBody, String string) {
        this.space();
        this.out.print("\"" + strategyBody.get_strategyBody() + "\"");
        this.needSpace = true;
    }

    public void after_xpathbody(XPath xPath, XPathBody xPathBody) {
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_xpathname(XPathDeclaration xPathDeclaration, XPathName xPathName) {
        this.space();
        this.out.print("XPath:");
        this.needSpace = false;
    }

    public void after_xpathname(XPathDeclaration xPathDeclaration, XPathName xPathName) {
        this.out.print(":");
        this.needSpace = false;
    }

    public void before_ident(XPathName xPathName, Ident ident) {
        this.space();
        this.out.print(xPathName.get_ident());
        this.needSpace = true;
    }

    public void before_xpathBody(XPathBody xPathBody, String string) {
        this.space();
        this.out.print("\"" + xPathBody.get_xpathBody() + "\"");
        this.needSpace = true;
    }

    public void before_s(Main main, String string) {
        this.space();
        this.out.print("\"" + main.get_s() + "\"");
        this.needSpace = true;
    }

    public void before_indent(PrintVisitor printVisitor, int n) {
        this.space();
        this.out.print(printVisitor.get_indent());
        this.needSpace = true;
    }

    public void before_needSpace(PrintVisitor printVisitor, boolean bl) {
        this.space();
        this.out.print(printVisitor.get_needSpace());
        this.needSpace = true;
    }

    public void before_copy(CopyVisitor copyVisitor, Object object) {
        this.space();
        this.out.print(copyVisitor.get_copy());
        this.needSpace = true;
    }

    public void before_is_equal(SubgraphVisitor subgraphVisitor, boolean bl) {
        this.space();
        this.out.print(subgraphVisitor.get_is_equal());
        this.needSpace = true;
    }

    public void before_is_equal(EqualVisitor equalVisitor, boolean bl) {
        this.space();
        this.out.print(equalVisitor.get_is_equal());
        this.needSpace = true;
    }

    public void before_indent(DisplayVisitor displayVisitor, int n) {
        this.space();
        this.out.print(displayVisitor.get_indent());
        this.needSpace = true;
    }

    public void before_indent(TraceVisitor traceVisitor, int n) {
        this.space();
        this.out.print(traceVisitor.get_indent());
        this.needSpace = true;
    }

    void universal_trv0_bef(UniversalVisitor universalVisitor) {
        super.universal_trv0_bef(universalVisitor);
    }

    void universal_trv0_aft(UniversalVisitor universalVisitor) {
        super.universal_trv0_aft(universalVisitor);
    }

    void universal_trv0(UniversalVisitor universalVisitor) {
        this.universal_trv0_bef(universalVisitor);
        super.universal_trv0(universalVisitor);
        this.universal_trv0_aft(universalVisitor);
    }
}

