/**
 * The default perspective used by the XAspectEditorPlugin. Provides 
 * location and layout for XEditor and XView objects, as well as a 
 * standard navigation window.
 * 
 * @author JSeifried
 * @version 0.2.5
 * @see jseifried.xaspecteditor.XAspectEditorPlugin
 * @see jseifried.xaspecteditor.XEditor
 * @see jseifried.xaspecteditor.view.XView
 */
package jseifried.xaspecteditor.perspective;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class XPerspective implements IPerspectiveFactory {

 public XPerspective() {}

 /**
  * Initializes the perspective.
  * 
  * @param layout the instance of IPageLayout associated with the current
  *               workbench.
  */
 public void createInitialLayout(IPageLayout layout)  {
  defineActions(layout);
  defineLayout(layout);
 }
   
 /**
  * Adds preferred actions to menus.
  * 
  * @param layout the instance of IPageLayout associated with the current
  *               workbench.
  */
 public void defineActions(IPageLayout layout) {
  layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
  layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
  layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
  layout.addShowViewShortcut("jseifried.xaspecteditor.xview");
  layout.addActionSet("jseifried.xaspecteditor.actionSet");
 }
   
 /**
  * Organizes objects in the perspective, and provides default locations.
  * 
  * @param layout the instance of IPageLayout associated with the current
  *               workbench.
  */
 public void defineLayout(IPageLayout layout) {
  String editorArea = layout.getEditorArea();
  IFolderLayout left =
    layout.createFolder("left", IPageLayout.LEFT, (float) 0.15, editorArea);
  IFolderLayout bottom =
    layout.createFolder("bottom", IPageLayout.BOTTOM, (float) 0.75, editorArea);
    left.addView(IPageLayout.ID_RES_NAV);
    bottom.addView("jseifried.xaspecteditor.xview");
 }
   
 /**
  * This perspective's lookup information for use by Eclipse.
  */
 public interface IPerspectivePlugin {
  public final static String PLUGIN_ID = "jseifried.xaspecteditor";       
  public final static String XPERSPECTIVE_PERSPECTIVE_ID = PLUGIN_ID + 
    ".xperspective";
 }
}
