/*
 * Decompiled with CFR 0.152.
 */
package jseifried.xaspecteditor.highlight;

import java.util.ArrayList;
import jseifried.xaspecteditor.highlight.IXAspectKeys;
import jseifried.xaspecteditor.highlight.XPunctuationRule;
import jseifried.xaspecteditor.highlight.XWordRule;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XRuleScanner
extends RuleBasedScanner
implements IXAspectKeys {
    private static Color COMMENT_COLOR = new Color((Device)Display.getCurrent(), new RGB(64, 160, 128));
    private static Color X_COLOR = new Color((Device)Display.getCurrent(), new RGB(0, 0, 200));

    public XRuleScanner() {
        Token commentToken = new Token((Object)new TextAttribute(COMMENT_COLOR));
        Token xToken = new Token((Object)new TextAttribute(X_COLOR));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)commentToken));
        rules.add(new MultiLineRule("/*", "*/", (IToken)commentToken));
        XWordRule wordRule = new XWordRule();
        XPunctuationRule punctRule = new XPunctuationRule();
        int i = 0;
        while (i < IXAspectKeys.cdwords.length) {
            wordRule.addWord(IXAspectKeys.cdwords[i], (IToken)xToken);
            ++i;
        }
        i = 0;
        while (i < IXAspectKeys.swords.length) {
            wordRule.addWord(IXAspectKeys.swords[i], (IToken)xToken);
            ++i;
        }
        i = 0;
        while (i < IXAspectKeys.nswords.length) {
            wordRule.addWord(IXAspectKeys.nswords[i], (IToken)xToken);
            ++i;
        }
        i = 0;
        while (i < IXAspectKeys.punctuation.length) {
            punctRule.addWord(IXAspectKeys.punctuation[i], (IToken)xToken);
            ++i;
        }
        rules.add((Object)wordRule);
        rules.add((Object)punctRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

