/*
 * Decompiled with CFR 0.152.
 */
package jseifried.xaspecteditor.dj;

import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.aplib.sg.Strategy;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import jseifried.xaspecteditor.dj.AspectLanguage_List;
import jseifried.xaspecteditor.dj.CDVisitor;
import jseifried.xaspecteditor.dj.ParseException;
import jseifried.xaspecteditor.dj.Parser;
import jseifried.xaspecteditor.dj.SelVisitor;
import jseifried.xaspecteditor.dj.UniversalVisitor;

public class XAspectLanguage {
    protected AspectLanguage_List aspectlanguage_list;

    public AspectLanguage_List get_aspectlanguage_list() {
        return this.aspectlanguage_list;
    }

    public void set_aspectlanguage_list(AspectLanguage_List new_aspectlanguage_list) {
        this.aspectlanguage_list = new_aspectlanguage_list;
    }

    public XAspectLanguage() {
    }

    public XAspectLanguage(AspectLanguage_List aspectlanguage_list) {
        this.set_aspectlanguage_list(aspectlanguage_list);
    }

    public static XAspectLanguage parse(Reader in) throws ParseException {
        return new Parser(in)._XAspectLanguage();
    }

    public static XAspectLanguage parse(InputStream in) throws ParseException {
        return new Parser(in)._XAspectLanguage();
    }

    public static XAspectLanguage parse(String s) {
        try {
            return XAspectLanguage.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static String validate(String string) throws Exception {
        try {
            XAspectLanguage xal = XAspectLanguage.parse(string);
            CDVisitor cdvisitor = new CDVisitor(xal, new Vector(), new Vector(), "");
            xal.universal_trv0(cdvisitor);
            SelVisitor selvisitor = new SelVisitor(cdvisitor.get_names(), cdvisitor.get_cgs(), "");
            xal.universal_trv0(selvisitor);
            return String.valueOf(cdvisitor.get_errors()) + selvisitor.get_errors();
        }
        catch (Exception e) {
            String error = e.getMessage();
            if (e.getClass() == new ArrayIndexOutOfBoundsException().getClass()) {
                error = "Unknown parse error.\n Check that referenced aspects are valid...\n";
            }
            return "ASPECT STRUCTURE PARSER ERROR: " + error + "\n - ASPECT STRUCTURE NOT PROCESSED -";
        }
    }

    private static ClassGraph getCG(String string, String cdname) {
        try {
            XAspectLanguage xal = XAspectLanguage.parse(string);
            CDVisitor cdvisitor = new CDVisitor(xal, new Vector(), new Vector(), "");
            xal.universal_trv0(cdvisitor);
            return (ClassGraph)cdvisitor.get_cgs().elementAt(cdvisitor.get_names().indexOf(cdname));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    private static Vector getNodes(String string, ClassGraph cg) {
        Strategy strategy = Strategy.fromString((String)string);
        try {
            Vector<String> nodes = new Vector<String>(new TraversalGraph(strategy.toSimpleStrategy(), (ClassGraphI)cg).getNodeSets());
            int ctr = 0;
            while (ctr < nodes.size()) {
                string = nodes.elementAt(ctr).toString();
                string = string.substring(0, string.indexOf(":"));
                nodes.setElementAt(string, ctr);
                ++ctr;
            }
            return nodes;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static Vector traceStrategy(String string, String cdname, String strategy) {
        ClassGraph cg = XAspectLanguage.getCG(string, cdname);
        Vector nodes = XAspectLanguage.getNodes(strategy, cg);
        Vector<Object> returnVal = new Vector<Object>();
        returnVal.add(cg.toString());
        returnVal.add(nodes);
        return returnVal;
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_aspectlanguage_list(this, this.aspectlanguage_list);
        this.aspectlanguage_list.universal_trv0(_v_);
        _v_.after_aspectlanguage_list(this, this.aspectlanguage_list);
        this.universal_trv0_aft(_v_);
    }
}

