/*
 * Decompiled with CFR 0.152.
 */
package jseifried.xaspecteditor;

import java.util.Vector;
import jseifried.xaspecteditor.XSourceViewerConfig;
import jseifried.xaspecteditor.dj.XAspectLanguage;
import jseifried.xaspecteditor.view.XView;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextEditor;

public class XEditor
extends TextEditor {
    private boolean traceActive;
    private XView xview;

    public XEditor() {
        this.setSourceViewerConfiguration(new XSourceViewerConfig());
        this.traceActive = false;
    }

    public void setXView(XView view) {
        this.xview = view;
    }

    public void activateTrace() {
        this.traceActive = true;
    }

    public void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        try {
            this.xview.refresh("", 0, 0, 0);
            if (this.isDirty()) {
                this.traceActive = false;
            }
            if (this.traceActive) {
                this.xview.refresh("Selector tracing active...", 0, 0, 200);
                int line = new Integer(this.getCursorPosition().substring(0, this.getCursorPosition().indexOf(":")).trim()) - 1;
                int column = new Integer(this.getCursorPosition().substring(this.getCursorPosition().indexOf(":") + 2).trim()) - 1;
                this.identifyLine(line, column);
            }
        }
        catch (Exception exception) {}
    }

    String getLine(int line) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        try {
            return doc.get(doc.getLineOffset(line), doc.getLineLength(line));
        }
        catch (Exception exception) {
            return null;
        }
    }

    void identifyLine(int line, int column) {
        String cd;
        String string = this.getLine(line).trim();
        if (!string.startsWith("declare")) {
            return;
        }
        String substring = string.substring(0, string.indexOf(":"));
        if (substring.endsWith("set")) {
            cd = this.getClassDictionaryName(line);
            this.showTrace(this.traceNodeSet(line, cd));
        }
        if (substring.endsWith("strategy")) {
            cd = this.getClassDictionaryName(line);
            this.showTrace(this.traceStrategy(line, cd));
        }
    }

    Vector traceStrategy(int line, String cd) {
        String contents = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
        String name = "Tracing Strategy " + this.getName(line) + ":";
        String strategy = this.getStrategy(line);
        Vector returnVal = XAspectLanguage.traceStrategy(contents, cd, strategy);
        returnVal.add(name);
        return returnVal;
    }

    String getStrategy(int line) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int offsetBegin = 0;
        int offsetEnd = 0;
        int current = 48;
        try {
            offsetBegin = doc.getLineOffset(line);
            while (current != 34) {
                current = doc.getChar(++offsetBegin);
            }
            current = 48;
            offsetEnd = offsetBegin + 1;
            while (current != 34) {
                current = doc.getChar(++offsetEnd);
            }
            return doc.get(offsetBegin + 1, offsetEnd - offsetBegin - 1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    Vector traceNodeSet(int line, String cd) {
        String contents = this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
        String name = "Tracing Node Set " + this.getName(line) + ":";
        this.getNodeSet(line);
        Vector returnVal = XAspectLanguage.traceStrategy(contents, cd, "from * to *");
        returnVal.add(name);
        return returnVal;
    }

    String getNodeSet(int line) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int offsetBegin = 0;
        int offsetEnd = 0;
        int current = 48;
        try {
            offsetBegin = doc.getLineOffset(line) + this.getLine(line).lastIndexOf(":");
            offsetEnd = offsetBegin + 1;
            while (current != 59) {
                current = doc.getChar(++offsetEnd);
            }
            return doc.get(offsetBegin + 1, offsetEnd - offsetBegin - 1).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    String getName(int line) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int offsetBegin = 0;
        int offsetEnd = 0;
        int current = 48;
        try {
            offsetBegin = doc.getLineOffset(line);
            while (current != 58) {
                current = doc.getChar(++offsetBegin);
            }
            current = 48;
            offsetEnd = offsetBegin + 1;
            while (current != 58) {
                current = doc.getChar(++offsetEnd);
            }
            return doc.get(offsetBegin + 1, offsetEnd - offsetBegin - 1).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    String getClassDictionaryName(int line) {
        String string = "";
        String returnVal = null;
        int index = 0;
        while (!string.startsWith("declare") || !string.endsWith("dictionary")) {
            if ((index = (string = this.getLine(++line).trim()).indexOf(":")) == -1) continue;
            string = this.getLine(line).trim().substring(0, index);
        }
        returnVal = this.getLine(line).trim().substring(index + 1, this.getLine(line).trim().indexOf(";")).trim();
        return returnVal;
    }

    void showTrace(Vector trace) {
        String string = String.valueOf(trace.elementAt(2).toString()) + "\n\n" + trace.elementAt(0).toString();
        this.xview.refresh(string, 0, 0, 200);
    }

    public void dispose() {
        this.xview.refresh("", 0, 0, 0);
        super.dispose();
    }
}

