/*
 * Decompiled with CFR 0.152.
 */
package RIDL_Runtime;

import RIDL_Runtime.RIDL_Object;
import RIDL_Runtime.RIDL_RN;
import RIDL_Runtime.RIDL_RemoteInst;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RIDL_Naming
extends UnicastRemoteObject
implements RIDL_RN {
    private static String lastinst;
    private static RIDL_RN rn;
    Hashtable hashtable = new Hashtable();

    public static RIDL_Object lookup(String host, int port, String name) throws RemoteException {
        RIDL_Naming.get_reg(host, port);
        RIDL_Object h = rn.lookup(name);
        return h;
    }

    public static void bind(String host, int port, String name, RIDL_Object obj) throws RemoteException {
        RIDL_Naming.get_reg(host, port);
        rn.bind(name, obj._make_fake());
    }

    public static void unbind(String host, int port, String name) throws RemoteException {
        RIDL_Naming.get_reg(host, port);
        rn.unbind(name);
    }

    public static String[] list(String host, int port) throws RemoteException {
        RIDL_Naming.get_reg(host, port);
        return rn.list();
    }

    private static void get_reg(String host, int port) {
        try {
            String hostport = host + ":" + port;
            if (!hostport.equals(lastinst) || rn == null) {
                lastinst = hostport;
                rn = (RIDL_RN)Naming.lookup("rmi://" + lastinst + "/RIDL_Naming");
            }
        }
        catch (RemoteException e) {
            System.err.println("Remote error occurred when accessing naming server on " + host + ":" + port);
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Could not find remote naming server on " + host + ":" + port + ".\n" + " Is a instantiation server running on that machine?");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("RIDL_Naming remote naming server\n Usage: java RIDL_Naming <portno>");
            System.exit(1);
        }
        int port = Integer.parseInt(args[0]);
        try {
            Registry r = LocateRegistry.createRegistry(port);
            System.err.println("made the registry");
            RIDL_Naming rn = new RIDL_Naming();
            RIDL_RemoteInst ri = new RIDL_RemoteInst();
            r.rebind("RIDL_RemoteInst", ri);
            r.rebind("RIDL_Naming", rn);
            System.err.println("bound the RIDL_Naming obj");
        }
        catch (RemoteException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public RIDL_Object lookup(String name) throws RemoteException {
        Object o = this.hashtable.get(name);
        return (RIDL_Object)o;
    }

    public void bind(String name, RIDL_Object r) throws RemoteException {
        this.hashtable.put(name, r);
    }

    public void unbind(String name) throws RemoteException {
        this.hashtable.remove(name);
    }

    public String[] list() throws RemoteException {
        String[] strs = new String[this.hashtable.size()];
        int i = 0;
        Enumeration e = this.hashtable.keys();
        while (e.hasMoreElements()) {
            strs[i++] = (String)e.nextElement();
        }
        return strs;
    }
}

