/**
 * This class provides some of the guidlines for keyword location by the 
 * XRuleScanner.
 * 
 * @author JSeifried
 * @version 0.1.0
 * @see XRuleScanner
 */
package jseifried.xaspecteditor.highlight;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WordPatternRule;

class WordBeginRule extends WordPatternRule {

 public WordBeginRule(IWordDetector detector, String startSequence, IToken token) {
  super(detector, startSequence, "", token);
 }

 protected boolean endSequenceDetected(ICharacterScanner scanner) {
  int c;
  while ((c = scanner.read()) != ICharacterScanner.EOF) {
   if (!fDetector.isWordPart((char)c)) {
    scanner.unread();
    return true;
   }
  }
  return false;
 }
}
