package jseifried.xaspecteditor.dj;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.aplib.sg.Strategy;
class SVisitor extends UniversalVisitor {
  protected ClassGraph cg;
  public ClassGraph get_cg() { return cg; }
  public void set_cg(ClassGraph new_cg) { cg = new_cg; }
  protected String errors;
  public String get_errors() { return errors; }
  public void set_errors(String new_errors) { errors = new_errors; }
  public SVisitor() { super(); }
  public SVisitor(ClassGraph cg, String errors) {
    super();
    set_cg(cg);
    set_errors(errors);
  }
  public static SVisitor parse(java.io.Reader in) throws ParseException { return new Parser(in)._SVisitor(); }
  public static SVisitor parse(java.io.InputStream in) throws ParseException { return new Parser(in)._SVisitor(); }
  public static SVisitor parse(String s) {
    try { return parse(new java.io.StringReader(s)); }
    catch (ParseException e) {
      throw new RuntimeException(e.toString());
    }
  }

   public void before(StrategyDef host) {
    Strategy strategy = Strategy.fromString(
      host.get_strategyexpr().get_strategy());
    try {
     TraversalGraph tg = new TraversalGraph(strategy.toSimpleStrategy(), cg);
    } catch (Exception e) {
     set_errors(errors + "STRATEGY DEFINITION ERROR: (in \"" + 
       host.get_strategyname().get_name().toString() + "\")\n");
     set_errors(errors + e.getMessage() + "\n");
    }
   }
 
  void universal_trv0_bef(UniversalVisitor _v_) {
    super.universal_trv0_bef(_v_);
    ((UniversalVisitor) _v_).before(this);
  }

  void universal_trv0_aft(UniversalVisitor _v_) {
    ((UniversalVisitor) _v_).after(this);
    super.universal_trv0_aft(_v_);
  }

  void universal_trv0(UniversalVisitor _v_) {
    universal_trv0_bef(_v_);
    ((UniversalVisitor) _v_).before_cg(this, cg);
    ((UniversalVisitor) _v_).after_cg(this, cg);
    ((UniversalVisitor) _v_).before_errors(this, errors);
    ((UniversalVisitor) _v_).after_errors(this, errors);
    super.universal_trv0(_v_);
    universal_trv0_aft(_v_);
  }

}
