/**
 * Provides the configuration data for the XEditor class, and defines the 
 * damage/reconcile behavior of the editor.
 * 
 * @author JSeifried
 * @version 0.4.0
 */
package jseifried.xaspecteditor;

import jseifried.xaspecteditor.highlight.XRuleScanner;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class XSourceViewerConfig extends SourceViewerConfiguration {

 /** The instance XRuleScanner in use by this configuration */
 private XRuleScanner scanner;
 
 /** The default text properties of the editor */ 
 private static Color DEFAULT_TAG_COLOR= new Color(Display.getCurrent(), 
   new RGB(0, 0, 0));

 public XSourceViewerConfig() {}

 /**
  * Creates an instance of the XRuleScanner for use with the reconciler
  * 
  * @return instance of the XRuleScanner
  * @see jseifried.xaspecteditor.highlight.XRuleScanner
  */
 protected XRuleScanner getTagScanner() {
  if (scanner == null) {
   scanner = new XRuleScanner();
   scanner.setDefaultReturnToken(new Token(
      new TextAttribute(DEFAULT_TAG_COLOR)));
  }
  return scanner;
 }

 /**
  * This is the configuration block for damage/reconcile behavior.
  * 
  * @param sourceViewer the instance of this class
  * @return the reconciler for the XEditor
  * @see jseifried.xaspecteditor.XEditor 
  */
 public IPresentationReconciler getPresentationReconciler(
   ISourceViewer sourceViewer) {
  PresentationReconciler reconciler = new PresentationReconciler();
  DefaultDamagerRepairer dr = new DefaultDamagerRepairer(getTagScanner());
  reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
  reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);
  return reconciler;
 }
}