package CSU670_Plugin.editors;

import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;

import CSU670_Plugin.actions.AspectXSyntaxHighlight;
import CSU670_Plugin.gen.Main;

public class AspectXEditor extends TextEditor {

	public static AspectXEditor current=null;
	public static int editorCount=0;
	
	//private ColorManager colorManager;

	public AspectXEditor() {
		super();
		current=this;
		editorCount++;
		
		//colorManager = new ColorManager();
		//setSourceViewerConfiguration(new XMLConfiguration(colorManager));
		setDocumentProvider(new AspectXDocumentProvider());
	}
	public void dispose() {
		if(current==this) current=null;
		editorCount--;
		//colorManager.dispose();
		super.dispose();
	}
	//get full text contents of this
	public String getText(){
		//if(((AspectXDocumentProvider)getDocumentProvider()).document == null)
		//	return "error couldnt get text";
		//return ((AspectXDocumentProvider)getDocumentProvider()).document.get();
		return getDocument().get();
	}
	public IDocument getDocument(){
		return getDocumentProvider().getDocument(getEditorInput());
	}
	
	public String getCursorPosition(){ return super.getCursorPosition(); }
	
	public void highlight(Color c,int start,int len){
		current.getSourceViewer().setTextColor(c,start,len,false);
	}
	public void highlight(Color c,IRegion r){
		highlight(c,r.getOffset(),r.getLength());
	}
	public void unhighlight(){
		highlight(AspectXSyntaxHighlight.black,0,getDocument().getLength());
	}
	public String currentStrategy() throws Exception{
		FindReplaceDocumentAdapter f = 
			new FindReplaceDocumentAdapter(getDocument());
		IRegion region;
		String strategy;
		
		String[]  p = AspectXEditor.current.getCursorPosition().split(":");
		int col = Integer.parseInt(p[0].trim())-1;
		int row = Integer.parseInt(p[1].trim())-1;
		//cursor position
		int pos = getDocument().getLineOffset(col)+row;
		
		//rewind to last declare
		region = f.find(pos,"declare",false,false,true,false);
		
		if(region==null) return "";
		
		//find strategy
		region = f.find(region.getOffset(),"declare strategy:[^:]+:[^;]+;",true,false,false,true);
		
		if(region==null) return "";
		
		if(region.getOffset()>pos || region.getOffset()+region.getLength()<pos)
			return "";
		
		AspectXEditor.current.highlight(AspectXSyntaxHighlight.magenta,region);
		
		strategy = f.subSequence(region.getOffset(),region.getOffset()+region.getLength()).toString();
		strategy = strategy.substring("declare strategy:".length());
		strategy = strategy.substring(strategy.indexOf(":")+1);
		strategy = strategy.substring(0,strategy.length()-1);
		return strategy.trim();
	}
	public void handleCursorPositionChanged(){
		unhighlight();
		AspectXSyntaxHighlight.instance.highlightKeywords();
		if(!Main.hadERROR)
			AspectXSyntaxHighlight.instance.run(null);
	}
	

}
