package aspectEditor.editors;



import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextEditor;

import aspectEditor.aspectEditorUtils.Main;

public class AspectEditor extends TextEditor {
	
	private ColorManager colorManager;
	public static IDocument myDoc;
	public static StyledText traversalViewer =null;
	
	//boolean to see if the button was pressed
	public static boolean buttonPressed=false;
	
	//setup the editor properties using the constructor
	public AspectEditor() {
		super();
		colorManager = new ColorManager();
		setSourceViewerConfiguration(new AspectConfiguration(colorManager));
		setDocumentProvider(new AspectDocumentProvider());
		//this.createVerticalRuler();
	}
	
	//splits the editor window
	//uses SytledText as space
	//traversal highling will show up in this area
	//Hint on this method give by Ayman
	public void createPartControl(Composite parent){
		super.createPartControl(parent);
		traversalViewer=new StyledText(parent, 1);
		traversalViewer.setEditable(false);
	}
	
	//gets out declaration line where cursor is over
	//using Brian Foster's suggestions
	public void handleCursorPositionChanged(){
		//if the button was pressed and the semantics were checked
		if(buttonPressed==true){
			IDocument doc = getDocumentProvider().getDocument(getEditorInput());
			FindReplaceDocumentAdapter f = new FindReplaceDocumentAdapter(doc);
			String cursorPos = this.getCursorPosition();
			String[] lineAndCol = cursorPos.split(" :");
			String lineString = lineAndCol[0];
			int line = Integer.parseInt(lineString);
			
			try {
				int beginningLineOffset= doc.getLineOffset(line);
				//search for the ';' at the end of the line
				Region toEnd = (Region)f.find(beginningLineOffset-3,";",true,false,false,false);
				int semiColonOffset = toEnd.getOffset();
				//System.out.println("Semi Colon Offset:"+semiColonOffset);
				
				//now search for the "declare" at the beginning of the line 
				Region wholeStatement = (Region)f.find(semiColonOffset,"declare",false,false,true,false);
				int declareStatementOffset = wholeStatement.getOffset();
				int length = semiColonOffset - declareStatementOffset ;
				
				//now highlight based on the line the cursor is over
				//plus one to get the ';' included in the result
				Main.highlight(doc.get(declareStatementOffset,length+1));
			} catch (BadLocationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}
	
}

