/*
 * Created on Nov 20, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package aspectEditor.editors;

/**
 * @author mtavares
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
import java.util.Enumeration;
import java.util.HashSet;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

import aspectEditor.aspectEditorUtils.ClassDictionaryL;
import aspectEditor.aspectEditorUtils.Main;
import aspectEditor.aspectEditorUtils.XAspectLanguage2;

public class DoubleClickStrategy implements ITextDoubleClickStrategy {
	protected ITextViewer fText;

	public void doubleClicked(ITextViewer part) {

		int pos = part.getSelectedRange().x;

		if (pos < 0)
			return;

		fText = part;

		if (!selectComment(pos)) {
			selectWord(pos);
		}
		
		int lineNum = fText.getSelectedRange().x;
		int lineNum2 = fText.getSelectedRange().y;
		String line = fText.getTextWidget().getSelectionText().toString();
		
		//get class dictionary out of editor//////////////////////
		String docToParse = AspectEditor.myDoc.get();
		XAspectLanguage2 s =  new XAspectLanguage2();
		s =  XAspectLanguage2.parse(docToParse);
		HashSet myCDNodeHash = new HashSet();
		
	    //setup iterator for list of aspects in the cd
	    Enumeration aspectEnumeration = s.get_aspectlanguage_list().elements();
	    String myClass = "";
	    //loops through aspect cd (will contain ClassDictionaries and Traversals)
	    while(aspectEnumeration.hasMoreElements())
	    {
	        Object currObj = aspectEnumeration.nextElement();
	     	String cdType = "aspectEditor.aspectEditorUtils.ClassDictionaryL";
	        String traversalType= "aspectEditor.aspectEditorUtils.SelectorL";
	        //check if it's a class dictionary then check semantics
	        if(cdType.equals(currObj.getClass().getName()))
	        {
	        	ClassDictionaryL currDict = (ClassDictionaryL)currObj;
	        	myClass = currDict.get_classdict().get_text().toString();
	        	//aspectEditor.traversalViewer.setText(myClass);
	        	edu.neu.ccs.demeter.aplib.cd.ClassGraph genericCG = edu.neu.ccs.demeter.aplib.cd.ClassGraph.parse(myClass);
	        	myCDNodeHash.addAll(genericCG.getNodes());
	        }
	    }
		//Main.highlight(myClass,line);
	
	}
	protected boolean selectComment(int caretPos) {
		IDocument doc = fText.getDocument();
		int startPos, endPos;

		try {
			int pos = caretPos;
			char c = ' ';

			while (pos >= 0) {
				c = doc.getChar(pos);
				if (c == '\\') {
					pos -= 2;
					continue;
				}
				if (c == Character.LINE_SEPARATOR || c == '\"')
					break;
				--pos;
			}

			if (c != '\"')
				return false;

			startPos = pos;

			pos = caretPos;
			int length = doc.getLength();
			c = ' ';

			while (pos < length) {
				c = doc.getChar(pos);
				if (c == Character.LINE_SEPARATOR || c == '\"')
					break;
				++pos;
			}
			if (c != '\"')
				return false;

			endPos = pos;

			int offset = startPos + 1;
			int len = endPos - offset;
			fText.setSelectedRange(offset, len);
			return true;
		} catch (BadLocationException x) {
		}

		return false;
	}
	protected boolean selectWord(int caretPos) {

		IDocument doc = fText.getDocument();
		int startPos, endPos;

		try {

			int pos = caretPos;
			char c;

			pos = caretPos;
			int length = doc.getLength();
			
			//modified here to stop highlighted region in editor at the ';' char
			while (pos < length) {
				c = doc.getChar(pos);
				if (c==';'){
					break;
				}
				++pos;
			}
			endPos = pos;
			
			//start working back from the end position (;)
			//to find the place where the highlighting is going to start
			pos=endPos;
			//if the first character encountered after the ';' is a '}'
			//we need a special case to geet worked back until we hit a '{'
			if(doc.getChar(pos-1)=='}'){
				while (pos >= 0) {
					c = doc.getChar(pos);
					if (c=='{'){
						--pos;
							break;
						}
					--pos;
				}
					
			}
			
			//if the character to the left of the ';' is not a '}'
			//we keep moving back until we hit a ':'
			else{
			while (pos >= 0) {
				c = doc.getChar(pos);
				if (c==':'){
						break;
				}
				--pos;
			}
			}
			startPos = pos;
			
			
			selectRange(startPos, endPos);
			return true;

		} catch (BadLocationException x) {
		}

		return false;
	}
	
	private void selectRange(int startPos, int stopPos) {
		int offset = startPos + 1;
		int length = stopPos - offset;
		fText.setSelectedRange(offset, length);
	}
}