/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.models.commands;

import java.util.List;

import org.eclipse.gef.commands.Command;
import APStudio.models.*;

public class OrphanChildCommand
	extends Command
{

private ClassGraphModel diagram;
private BasicSubpart child;
private int index;

public OrphanChildCommand () {
	super("OrphanChildCommand");
}

public void execute() {
	List children = diagram.getChildren();
	index = children.indexOf(child);
	diagram.removeChild(child);
}

public void redo() {
	diagram.removeChild(child);
}

public void setChild(BasicSubpart child) {
	this.child = child;
}

public void setParent(ClassGraphModel parent) { 
	diagram = parent;
}

public void undo() {
	diagram.addChild(child,index);
}

}
