/*
 * Created on Aug 10, 2003
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package APStudio.models;



import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.Bendpoint;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
/**
 * @author rajags
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class Connector extends BasicElement{
	private static int count;
	private BasicSubpart _source;
	private BasicSubpart _target;
	private String defaultName = "Connection";
	private String _name = "";
	protected static IPropertyDescriptor[] descriptors = null;
	protected boolean _traversed;
//	protected boolean ConOrAlt;
	/** Indicator for if a class is traversed by a strategy **/
	private boolean _value = false;
	/** List of bendpoint model object associated with current connection model object. */
	protected List bendpoints = new ArrayList();
	
	/** Source terminal name. */  
	protected String _sourceTerminal;

	/** Target terminal name. */  
	protected String _targetTerminal;
	

	public static String ID_NAME="Name";
	
	static{
		descriptors = new IPropertyDescriptor[]{
			new TextPropertyDescriptor(ID_NAME,"Name")
		};
	}
	public Connector(){
		//set the name
		_name = defaultName+ this.getID();
//		ConOrAlt = type;
	}
	protected String getNewID() {
		return Integer.toString(count++);
	}
	/** Sets the connection source. */
	public void setSource(BasicSubpart source)
	{
		Object old = _source;
	  	_source = source;
	  	firePropertyChange("source", old, _source);
	}

	/** Sets the connection target. */  
	public void setTarget(BasicSubpart target)
	{
	  _target = target;
	}

	/** Gets the connection source. */
	public BasicSubpart getSource(){
	  return _source;
	}

	/** Gets the connection target. */
	public BasicSubpart getTarget(){
	  return _target;
	}

	/**
	 * Returns useful property descriptors for the use
	 * in property sheets. this supports location ,
	 * size and Name.
	 *
	 * @return  Array of property descriptors.
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return descriptors;
	}

	/**
	 * Returns an Object which represents the appropriate
	 * value for the property name supplied.
	 *
	 * @param propName  Name of the property for which the
	 *                  the values are needed.
	 * @return  Object which is the value of the property.
	 */
	public Object getPropertyValue(Object propName) {
		if(ID_NAME.equals(propName))
			return new String(getName());
		return null;
	}
	

	
	/** Returns the list of bendpoints model objects. */
	public List getBendpoints() {
	  return bendpoints;
	}
  
  
	/**
	 * Inserts a bendpoint.
	**/
	public void insertBendpoint(int index, Bendpoint point) {
	  getBendpoints().add(index, point);
	  firePropertyChange("bendpoint", null, null);
	}

	/**
	 * Removes a bendpoint.
	**/
	public void removeBendpoint(int index) {
	  getBendpoints().remove(index);
	  firePropertyChange("bendpoint", null, null);
	}

	/**
	 * Sets another location for an existing bendpoint.
	**/
	public void setBendpoint(int index, Bendpoint point)
	{
	  getBendpoints().set(index, point);
	  firePropertyChange("bendpoint", null, null);
	}

	/**
	 * Sets the value of a given property with the value
	 * supplied. Also fires a property change if necessary.
	 * 
	 * @param id  Name of the parameter to be changed.
	 * @param value  Value to be set to the given parameter.
	 */
	public void setPropertyValue(Object id, Object value){
		 if(ID_NAME.equals(id)){
			setName((String)value);
		}
	}
	
	public void setTraversed(boolean newValue){
		Object oldValue = Boolean.valueOf(_traversed);
		_traversed = newValue;
		firePropertyChange("Traversed",oldValue,Boolean.valueOf(newValue));
	}
	
	/**
	 * 
	 *
	 */
	public void attachSource(){
	  if (getSource() == null)
		  return;
	  getSource().connectOutput(this);
	}

	/**
	 * 
	 *
	 */
	public void attachTarget(){
	  if (getTarget() == null)
		  return;
	  getTarget().connectInput(this);
	}

	/**
	 * 
	 *
	 */
	public void detachSource(){
	  if (getSource() == null)
		  return;
	  getSource().disconnectOutput(this);
	}

	/**
	 * 
	 *
	 */
	public void detachTarget(){
	  if (getTarget() == null)
		  return;
	  getTarget().disconnectInput(this);
	}


	/**
	 * Sets the name of the source terminal.
	**/
	public void setSourceTerminal(String s){
	
	  Object old = _sourceTerminal;
	 _sourceTerminal = s;
	firePropertyChange("sourceTerminal", old, _sourceTerminal);//$NON-NLS-1$
	}

	/**
	 * Sets the name of the target terminal.
	**/
	public void setTargetTerminal(String s){
	  _targetTerminal = s;
	}
  
	/** Gets source terminal name. */
	public String getSourceTerminal()
	{
	  return _sourceTerminal;
	}

	/** Gets source terminal name. */
	public String getTargetTerminal()
	{
	  return _targetTerminal;
	}




	public void setName(String iName)
	{
	  _name = iName;
	  firePropertyChange("Name",null,_name);
	}
	
	public String getName(){
		return _name;
		
	}
	
	public String toString()
	{
	  return _name;
	}
	
	/**
	 * 
	 * @return true if traversed . false otherwise.
	 * 
	 */
	public boolean getValue(){
		return _value;
	}
	
	abstract public boolean is_ConOrAlt();
	
//	Try to use the Value property instead of the traversed property
	public void setValue(boolean value){
		if (value == this._value) return;
		this._value = value;
		if (_target != null)
			_target.update();
		firePropertyChange("value", null, null);//$NON-NLS-1$
	}
	
	
}
