/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.figures;

import org.eclipse.draw2d.*;
import org.eclipse.draw2d.geometry.*;

public class FixedConnectionAnchor 
	extends AbstractConnectionAnchor
{

private Object direction;
public int index = 0;
//public boolean in_out = true;

public FixedConnectionAnchor(IFigure owner) {
	super(owner);
}

/**
 * @see org.eclipse.draw2d.AbstractConnectionAnchor#ancestorMoved(IFigure)
 */
public void ancestorMoved(IFigure figure) {
	if (figure instanceof ScalableFreeformLayeredPane)
		return;
	super.ancestorMoved(figure);
}

public Point getLocation(Point reference) {
	Rectangle r = getOwner().getBounds();
	int x = r.x, y = r.y;

/*	if(in_out){
		switch(index){
			case 1:
				x = r.x;
				y = r.y + r.height/3;
				break;
			case 2:
				x = r.x + r.width/3;
				y = r.y;
				break;
			case 3:
				x = r.right();
				y = r.y + r.height/3;
				break;
			case 4:
				x = r.x + r.width/3;
				y = r.bottom();
				break;
		}
	}
	else{*/
		switch(index){
			case 0:
				x = r.x;
				y = r.y + r.height/2;
				break;
			case 1:
				x = r.x + r.width/2;
				y = r.y;
				break;
			case 2:
				x = r.right();
				y = r.y + r.height/2;
				break;
			case 3:
				x = r.x + r.width/2;
				y = r.bottom();
				break;
		}
//	}

	Point p = new PrecisionPoint(x,y);
	getOwner().translateToAbsolute(p);
	return p;
}

public Point getReferencePoint(){
	return getLocation(null);
}
	
}