/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;

import APStudio.models.Connector;

public class FigureFactory {

public static PolylineConnection createNewBendableConnecotr(Connector wire){
	PolylineConnection conn = new PolylineConnection();
//	conn.setSourceDecoration(new PolygonDecoration());
//	conn.setTargetDecoration(new PolylineDecoration());
	return conn;
}

public static PolylineConnection createNewConnector(Connector wire){

	PolylineConnection conn = new PolylineConnection();
	PolygonDecoration arrow;
	
	if (wire == null)
		arrow = null;
	else {
		arrow = new PolygonDecoration();
		arrow.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
		arrow.setScale(5,2.5);
	}
	conn.setSourceDecoration(arrow);
	
	if (wire == null )
		arrow = null;
	else {
		arrow = new PolygonDecoration();
		arrow.setTemplate(PolygonDecoration.INVERTED_TRIANGLE_TIP);
		arrow.setScale(5,2.5);
	}
	conn.setTargetDecoration(arrow);
	return conn;
}

public static IFigure createNewClass(){
	return new ClassFigure();
}
}