/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.editparts;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

import APStudio.figures.ClassFigure;

final public class LabelCellEditorLocator
	implements CellEditorLocator
{

private ClassFigure cfig;

public LabelCellEditorLocator(ClassFigure figure) {
	setLabel(figure);
}

public void relocate(CellEditor celleditor) {
	Text text = (Text)celleditor.getControl();
	Point sel = text.getSelection();
	Point pref = text.computeSize(-1, -1);
	Rectangle rect = cfig.getBounds().getCopy();
	cfig.translateToAbsolute(rect);
	text.setBounds(rect.x-4, rect.y-1, pref.x+1, pref.y+1);	
	text.setSelection(0);
	text.setSelection(sel);
}

/**
 * Returns the Label figure.
 */
protected ClassFigure getLabel() {
	return cfig;
}

/**
 * Sets the label.
 * @param label The label to set
 */
protected void setLabel(ClassFigure figure) {
	this.cfig = figure;
}

}
