/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.editparts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

import APStudio.figures.FigureFactory;
import APStudio.figures.NodeFigure;
import APStudio.models.BasicSubpart;
import APStudio.models.Connector;
import APStudio.models.commands.ConnectionCommand;

public class APNodeEditPolicy
	extends org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy
{

protected Connection createDummyConnection(Request req) {
	PolylineConnection conn = FigureFactory.createNewConnector(null);
	return conn;
}

protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {	
	ConnectionCommand command = (ConnectionCommand)request.getStartCommand();
	command.setTarget(getBasicSubpart());
	ConnectionAnchor ctor = getAbstractAPEditPart().getTargetConnectionAnchor(request);
	if (ctor == null)
		return null;
	command.setTargetTerminal(getAbstractAPEditPart().mapConnectionAnchorToTerminal(ctor));
	return command;
}

protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
	ConnectionCommand command = new ConnectionCommand();
//	System.out.println("here"+request);
//	command.setConnector(new AlternationConnector());
	command.setSource(getBasicSubpart());
	ConnectionAnchor ctor = getAbstractAPEditPart().getSourceConnectionAnchor(request);
	command.setSourceTerminal(getAbstractAPEditPart().mapConnectionAnchorToTerminal(ctor));
	request.setStartCommand(command);
	return command;
}

protected AbstractAPEditPart getAbstractAPEditPart() {
	return (AbstractAPEditPart) getHost();
}

protected BasicSubpart getBasicSubpart() {
	return (BasicSubpart) getHost().getModel();
}

protected Command getReconnectTargetCommand(ReconnectRequest request) {
		
	ConnectionCommand cmd = new ConnectionCommand();
	cmd.setConnector((Connector)request.getConnectionEditPart().getModel());

	ConnectionAnchor ctor = getAbstractAPEditPart().getTargetConnectionAnchor(request);
	cmd.setTarget(getBasicSubpart());
	cmd.setTargetTerminal(getAbstractAPEditPart().mapConnectionAnchorToTerminal(ctor));
	return cmd;
}

protected Command getReconnectSourceCommand(ReconnectRequest request) {
	ConnectionCommand cmd = new ConnectionCommand();
	cmd.setConnector((Connector)request.getConnectionEditPart().getModel());

	ConnectionAnchor ctor = getAbstractAPEditPart().getSourceConnectionAnchor(request);
	cmd.setSource(getBasicSubpart());
	cmd.setSourceTerminal(getAbstractAPEditPart().mapConnectionAnchorToTerminal(ctor));
	return cmd;
}

protected NodeFigure getNodeFigure() {
	return (NodeFigure)((GraphicalEditPart)getHost()).getFigure();
}

}