/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package APStudio.editors;

import org.eclipse.core.runtime.Status;

import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ISharedImages;

import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.ErrorDialog;

import APStudio.ResourceMgtUtils;

/**
 * Manages the installation/deinstallation of global actions for multi-page editors.
 * Responsible for the redirection of global actions to the active editor.
 * Multi-page contributor replaces the contributors for the individual editors in the multi-page editor.
 */
public class MultiPageEditorContributor extends MultiPageEditorActionBarContributor {
	private IEditorPart activeEditorPart;
	private Action sampleAction;
	private Action linkAction;
	/**
	 * Creates a multi-page contributor.
	 */
	public MultiPageEditorContributor() {
		super();
		createActions();
	}
	/**
	 * Returns the action registed with the given text editor.
	 * @return IAction or null if editor is null.
	 */
	protected IAction getAction(ITextEditor editor, String actionID) {
		return (editor == null ? null : editor.getAction(actionID));
	}
	/* (non-JavaDoc)
	 * Method declared in AbstractMultiPageEditorActionBarContributor.
	 */

	public void setActivePage(IEditorPart part) {
		if (activeEditorPart == part)
			return;

		activeEditorPart = part;

		IActionBars actionBars = getActionBars();
		if (actionBars != null) {

			ITextEditor editor = (part instanceof ITextEditor) ? (ITextEditor) part : null;

			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.DELETE,
				getAction(editor, ITextEditorActionConstants.DELETE));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.UNDO,
				getAction(editor, ITextEditorActionConstants.UNDO));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.REDO,
				getAction(editor, ITextEditorActionConstants.REDO));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.CUT,
				getAction(editor, ITextEditorActionConstants.CUT));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.COPY,
				getAction(editor, ITextEditorActionConstants.COPY));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.PASTE,
				getAction(editor, ITextEditorActionConstants.PASTE));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.SELECT_ALL,
				getAction(editor, ITextEditorActionConstants.SELECT_ALL));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.FIND,
				getAction(editor, ITextEditorActionConstants.FIND));
			actionBars.setGlobalActionHandler(
				IWorkbenchActionConstants.BOOKMARK,
				getAction(editor, ITextEditorActionConstants.BOOKMARK));
			actionBars.updateActionBars();
		}
	}
	private void createActions() {
		sampleAction = new Action() {
			public void run() {
				//This is where the classGraph needs to be generated.
				ResourceMgtUtils.createClassGraph();
		
				String error =ResourceMgtUtils.HighlightTraversal();
				if(!error.equals(""))
				{
					ErrorDialog.openError(null,
						"APStudio Plug-in",
						"Check the strategy String",
						new Status(Status.ERROR,"APStudio",Status.OK,error,null));
				}	
				
			}
		};
		sampleAction.setText("HighLight Traversal");
		sampleAction.setToolTipText("Click to highlight the traversal");
		sampleAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
				getImageDescriptor(ISharedImages.IMG_OBJS_TASK_TSK));
		
		
	}
	public void contributeToMenu(IMenuManager manager) {
		IMenuManager menu = new MenuManager("APStudio &Menu");
		manager.prependToGroup(IWorkbenchActionConstants.MB_ADDITIONS, menu);
		menu.add(sampleAction);
	}
	public void contributeToToolBar(IToolBarManager manager) {
		manager.add(new Separator());
		manager.add(sampleAction);
	}
}
