/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib.sg;

import edu.neu.ccs.demeter.aplib.ConstraintMapI;
import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.NameMapI;
import edu.neu.ccs.demeter.aplib.SimpleStrategyI;
import edu.neu.ccs.demeter.aplib.StrategyGraphI;
import edu.neu.ccs.demeter.aplib.sg.DisplayVisitor;
import edu.neu.ccs.demeter.aplib.sg.GlobSpec;
import edu.neu.ccs.demeter.aplib.sg.NameMap;
import edu.neu.ccs.demeter.aplib.sg.ParseException;
import edu.neu.ccs.demeter.aplib.sg.Parser;
import edu.neu.ccs.demeter.aplib.sg.PrintVisitor;
import edu.neu.ccs.demeter.aplib.sg.SGEdge;
import edu.neu.ccs.demeter.aplib.sg.SGEdge_SList;
import edu.neu.ccs.demeter.aplib.sg.SimpleStrategy;
import edu.neu.ccs.demeter.aplib.sg.SymbolicNameMapI;
import edu.neu.ccs.demeter.aplib.sg.UniversalVisitor;
import edu.neu.ccs.demeter.aplib.sg.__V_PathDirective_toGraph;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StrategyGraph
extends SimpleStrategy
implements SimpleStrategyI,
StrategyGraphI,
ConstraintMapI {
    protected SGEdge_SList edges;
    List edgeList = new ArrayList();
    Map nodes = new HashMap();
    Set sources = new HashSet();
    Set targets = new HashSet();
    SymbolicNameMapI nameMap = null;
    NameMapI memoN;
    NameMapI composedN;

    public SGEdge_SList get_edges() {
        return this.edges;
    }

    public void set_edges(SGEdge_SList new_edges) {
        this.edges = new_edges;
    }

    public StrategyGraph(NameMap parsedNameMap, SGEdge_SList edges) {
        super(parsedNameMap);
        this.set_edges(edges);
    }

    public static StrategyGraph parse(Reader in) throws ParseException {
        return new Parser(in)._StrategyGraph();
    }

    public static StrategyGraph parse(InputStream in) throws ParseException {
        return new Parser(in)._StrategyGraph();
    }

    public static StrategyGraph parse(String s) {
        try {
            return StrategyGraph.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public StrategyGraph() {
        this.edges = new SGEdge_SList();
    }

    StrategyGraph toGraph() {
        if (this.edgeList.isEmpty()) {
            Enumeration e = this.edges.elements();
            int i = 0;
            HashSet<GlobSpec> allSources = new HashSet<GlobSpec>();
            HashSet<GlobSpec> allTargets = new HashSet<GlobSpec>();
            while (e.hasMoreElements()) {
                SGEdge edge = (SGEdge)e.nextElement();
                this.addEdge(edge, i++);
                allSources.add(edge.get_source());
                allTargets.add(edge.get_target());
            }
            if (this.sources.isEmpty()) {
                this.sources = allSources;
            }
            if (this.targets.isEmpty()) {
                this.targets = allTargets;
            }
            if (this.nameMap == null) {
                this.nameMap = this.parsedNameMap == null ? new NameMap() : this.parsedNameMap;
            }
            this.parsedNameMap = null;
        }
        return this;
    }

    public void addEdge(SGEdge edge) {
        this.addEdge(edge, this.edges.size());
        this.edges.addElement(edge);
    }

    void addEdge(SGEdge edge, int i) {
        IncidentEdges ie;
        this.edgeList.add(edge);
        GlobSpec source = edge.get_source();
        if (edge.isSource()) {
            this.sources.add(source);
        }
        if ((ie = (IncidentEdges)this.nodes.get(source)) == null) {
            ie = new IncidentEdges();
            this.nodes.put(source, ie);
        }
        ie.outgoing.add(new Integer(i));
        GlobSpec target = edge.get_target();
        if (edge.isTarget()) {
            this.targets.add(target);
        }
        if ((ie = (IncidentEdges)this.nodes.get(target)) == null) {
            ie = new IncidentEdges();
            this.nodes.put(target, ie);
        }
        ie.incoming.add(new Integer(i));
    }

    public SimpleStrategyI toSimpleStrategy() {
        return this.toGraph();
    }

    public StrategyGraphI getStrategyGraph() {
        return this;
    }

    public Collection getSources() {
        return Collections.unmodifiableCollection(this.sources);
    }

    public Collection getTargets() {
        return Collections.unmodifiableCollection(this.targets);
    }

    public Collection getNames(Object v) {
        return ((GlobSpec)v).collectClassGlobs().map(this.nameMap);
    }

    public ConstraintMapI getConstraintMap() {
        return this;
    }

    public Collection getNodes() {
        return Collections.unmodifiableCollection(this.nodes.keySet());
    }

    public Collection getIncomingEdges(Object v) {
        IncidentEdges ie = (IncidentEdges)this.nodes.get(v);
        return ie == null ? null : ie.incoming;
    }

    public Collection getOutgoingEdges(Object v) {
        IncidentEdges ie = (IncidentEdges)this.nodes.get(v);
        return ie == null ? null : ie.outgoing;
    }

    public int numEdges() {
        return this.edgeList.size();
    }

    public Object getEdgeSource(int i) {
        return ((SGEdge)this.edgeList.get(i)).get_source();
    }

    public Object getEdgeTarget(int i) {
        return ((SGEdge)this.edgeList.get(i)).get_target();
    }

    public boolean meetsConstraint(int i, Object v, NameMapI N) {
        SGEdge sgedge = (SGEdge)this.edgeList.get(i);
        return sgedge.meetsConstraint(v, this.composeNameMap(N));
    }

    public boolean meetsConstraint(int i, EdgeI e, NameMapI N) {
        SGEdge sgedge = (SGEdge)this.edgeList.get(i);
        return sgedge.meetsConstraint(e, this.composeNameMap(N));
    }

    public boolean meetsConstraint(Object a, Object v, NameMapI N) {
        return ((GlobSpec)a).match(v, this.composeNameMap(N));
    }

    public boolean meetsConstraint(Object a, EdgeI e, NameMapI N) {
        return ((GlobSpec)a).match(e, this.composeNameMap(N));
    }

    NameMapI composeNameMap(NameMapI N) {
        if (N != this.memoN) {
            this.memoN = N;
            this.composedN = N == null ? this.nameMap : (this.nameMap == null ? N : NameMap.compose(N, this.nameMap));
        }
        return this.composedN;
    }

    public String toString() {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        this.universal_trv0(new PrintVisitor(pw));
        pw.flush();
        return w.toString();
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        super.universal_trv0_bef(_v_);
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
        super.universal_trv0_aft(_v_);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_edges(this, this.edges);
        this.edges.universal_trv0(_v_);
        _v_.after_edges(this, this.edges);
        super.universal_trv0(_v_);
        this.universal_trv0_aft(_v_);
    }

    void __trav_display_SelectorLanguage_trv_bef(DisplayVisitor __v0) {
        super.__trav_display_SelectorLanguage_trv_bef(__v0);
        __v0.before(this);
    }

    void __trav_display_SelectorLanguage_trv_aft(DisplayVisitor __v0) {
        __v0.after(this);
        super.__trav_display_SelectorLanguage_trv_aft(__v0);
    }

    void __trav_display_SelectorLanguage_trv(DisplayVisitor __v0) {
        this.__trav_display_SelectorLanguage_trv_bef(__v0);
        __v0.before_edges(this, this.edges);
        this.edges.__trav_display_SelectorLanguage_trv(__v0);
        __v0.after_edges(this, this.edges);
        super.__trav_display_SelectorLanguage_trv(__v0);
        this.__trav_display_SelectorLanguage_trv_aft(__v0);
    }

    void toAll_StrategyExpression_trv_bef(UniversalVisitor __v0) {
        super.toAll_StrategyExpression_trv_bef(__v0);
        __v0.before(this);
    }

    void toAll_StrategyExpression_trv_aft(UniversalVisitor __v0) {
        __v0.after(this);
        super.toAll_StrategyExpression_trv_aft(__v0);
    }

    void toAll_StrategyExpression_trv(UniversalVisitor __v0) {
        this.toAll_StrategyExpression_trv_bef(__v0);
        __v0.before_edges(this, this.edges);
        this.edges.toAll_StrategyExpression_trv(__v0);
        __v0.after_edges(this, this.edges);
        super.toAll_StrategyExpression_trv(__v0);
        this.toAll_StrategyExpression_trv_aft(__v0);
    }

    void __trav_toGraph_PathDirective_trv(__V_PathDirective_toGraph __v0) {
    }

    class IncidentEdges {
        List incoming = new ArrayList();
        List outgoing = new ArrayList();

        IncidentEdges() {
        }
    }
}

