package com.ibm.lab.soln.resources.nature_builder;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
 
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

import com.ibm.lab.soln.resources.ActionResourceAction;

/**
 * Implements an action that lists all the builders associated with the 
 * selected project. 
 * <p>
 * This demonstrates the API for the project and project description 
 * workspace resources and how you might implement this logic in your tool.
 * </p>
 * @see org.eclipse.core.resources.IProject
 * @see org.eclipse.core.resources.IProjectDescription
 * @see org.eclipse.core.resources.ICommand
 */

public class ActionListBuilders extends ActionResourceAction {

   /**
    * ActionListBuilders default constructor.
    */
   public ActionListBuilders() {
      super();
   }

   /**
    * Uses saved reference to selected project to call custom logic that
    * lists the builder for the current project.
    * 
    * @see org.eclipse.ui.IActionDelegate#run(IAction)
    * 
    * @param action action proxy that handles the presentation
    * portion of the plugin action
    */
   public void run(org.eclipse.jface.action.IAction action) {
      // Get project selected in Navigator
      // Extenstion definition filters to just single IProject selection
      IProject project = (IProject) this.selection.iterator().next();

      try {
         // Get and list BuildSpec/Build Commands
         listBuildCommands(project);

      } catch (CoreException e) {
         e.printStackTrace();

         // Problem with List Builders
         resultError(
            "Soln: Resource - List Builders Request",
            "Problem getting BuildSpec/Commands from Project.");
      }
   }

   /**
    * Lists the builders associated with the passed project.
    *
    * @param project  selected project resource is input for processing
    */
   public void listBuildCommands(IProject project) throws CoreException {

      // Get project selected in Navigator
      // Extenstion definition filters to just single IProject selection
      ICommand[] commands = project.getDescription().getBuildSpec();
      String builderList = new String();

      // Show current Project
      builderList = builderList.concat("> Selected Project: " + project + "\n");

      // List existing builders
      for (int i = 0; i < commands.length; ++i) {
         builderList =
            builderList.concat(
               "\t> Builder: " + commands[i].getBuilderName() + "\n");
      }
      // List Builders
      resultInformation("Soln: Resource - List Builders Request", builderList);

   }
}
