package com.ibm.lab.soln.resources;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

/**
 * Definition of common strings that were used as plug-in extension ids.
 * Some of these fields represent values defined in the 
 * com.ibm.lab.soln.dialogs plug-in. They are specified here to avoid having a 
 * formal dependancy on the Dialogs plugin.
 */
public interface IResourceIDs {
  /** Global Trace Control */
  public final boolean TRACE_ENABLED = true;

  /** identifier of nature in plugin.xml - (concatenate pluginid.natureid) */
  public final java.lang.String NATURE_ID = "com.ibm.lab.soln.resources.customnature";

  /** id of builder - matches plugin.xml (concatenate pluginid.builderid) */
  public final java.lang.String BUILDER_ID = "com.ibm.lab.soln.resources.readmebuilder";

  /** id of marker - matches plugin.xml (concatenate pluginid.markerid) */
  public final java.lang.String MARKER_ID = "com.ibm.lab.soln.resources.recentEdits";

  /** path for where readme files will be found */
  public final IPath README_FOLDER = new Path("readme");

  /** Key for boolean value that can be stored as a resource property.
   * Created by the com.ibm.lab.soln.dialogs plugin if available
   * If the value changes here, it must also change in the IDialogsIDs interface
   */
  public static QualifiedName REDIT_PROPERTY_KEY =
    new QualifiedName("com.ibm.lab.soln.dialogs", "Recent_Edits");

  /** Key for boolean value to be stored as a resource property.
   * Used by the com.ibm.lab.soln.resources plugin if available
   * If the value changes here, it must also change in the IDialogsIDs interface
   */
  public static String REDIT_PREFERENCES_KEY = "Recent_Edits_Limit";

  /** Key for boolean value to be stored as a resource property.
   * Used by the com.ibm.lab.soln.resources plugin if available.
   * If the value changes here, it must also change in the IResourceIDs interface.
   */
  public static String REDIT_PREFERENCES_KEY2 = "Recent_Edits_Persistence";

}
