package com.ibm.lab.soln.resources;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

/**
 * Multi-headed action that used to request that a workspace 
 * resource change listener be added or removed.
 */
public class ActionManageTraceRCLs
  extends ActionResourceAction
  implements IViewActionDelegate {

  /**
   * ActionManageTraceRCLs default constructor.
   */
  public ActionManageTraceRCLs() {
    super();
  }

  /**
   * Determines type of request by inspecting UI action that triggered 
   * this method. 
   * 
   * @see org.eclipse.ui.IActionDelegate#run(IAction)
   *
   * @param action the action proxy that handles the presentation portion of the
   *   action
   */
  public void run(IAction action) {

    try {
      if (action.getId().equals("addRCL")) {
        attemptRCLAdd();
      } else {
        if (action.getId().equals("removeRCL")) {
          attemptRCLRemove();
        }
      }

    } catch (CoreException e) {
      resultInformation(
        "Soln: Resource - Trigger Plug-in Request",
        "An unexpected exception was thrown.");
      e.printStackTrace();
    }
  }

  /**
   * Add the RCL - return from plug-in service method indicates success
   */
  public void attemptRCLAdd() throws CoreException {
    if (EDUResourcesPlugin.getDefault().addMy_RCL())
      resultInformation(
        "Soln: Resource - Add Tracing RCL Request",
        "Resource Change Listener added to workspace.");
    else
      resultError(
        "Soln: Resource - Add Tracing RCL Request",
        "Resource Change Listener previously added.");
  }

  /**
   * Remove the RCL - return from plug-in service method indicates success
   */
  public void attemptRCLRemove() throws CoreException {
    if (EDUResourcesPlugin.getDefault().removeMy_RCL())
      resultInformation(
        "Soln: Resource - Remove Tracing RCL Request",
        "Resource Change Listener removed from workspace.");
    else
      resultError(
        "Soln: Resource - Remove Tracing RCL Request",
        "Resource Change Listener does not exist to remove.");
  }

  /* non-Javadoc
   * 
   * Not used in this action - implemented per 
   * <code>IViewActionDelegate</code> interface.
   * 
   * @see org.eclipse.ui.IViewActionDelegate#init(IViewPart)
   */
  public void init(IViewPart view) {
  }

}