package com.ibm.lab.soln.dialogs;
/*
 * "The Java Developer's Guide to Eclipse"
 *   by Shavor, D'Anjou, Fairbrother, Kehn, Kellerman, McCarthy
 * 
 * (C) Copyright International Business Machines Corporation, 2003. 
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/**
 * Supports a workbench action that opens a wizard. Creates the wizard dialog, adds
 * the wizard, and opens the dialog to support wizard processing.
 */
public class MyWizardAction implements IObjectActionDelegate {
  // local reference to user interface selection
  private org.eclipse.jface.viewers.IStructuredSelection mySelection;

  // switch to control write of trace data
  private boolean traceEnabled = false;

  /**
   * Constructor for MyWizardAction.
   */
  public MyWizardAction() {
    super();
  }

  /**
   * Creates an instance of the wizard and then uses a 
   * to directly open the wizard.
   * @see IActionDelegate#run(IAction)
   */
  public void run(IAction action) {
    traceMsg("MWizardSet: -------> in my action");

    // get the plugin for tracing purposes
    if (traceEnabled)
      getPluginHandle();

    // Create the wizard
    StructureWizard wizard = new StructureWizard();
    wizard.init(getWorkbench(), mySelection);

    // Create the dialog to wrap the wizard
    WizardDialog dialog =
      new WizardDialog(
        getWorkbench().getActiveWorkbenchWindow().getShell(),
        wizard);

    dialog.open();

  }

  /**
   * Generates trace messages to show which plug-in is in use.
   */
  private void getPluginHandle() {

    Plugin myPlugin = Platform.getPlugin("com.ibm.lab.soln.dialogs");
    traceMsg("\tUsing this plug-in:");
    traceMsg("\t\t" + myPlugin.getClass());
    traceMsg(
      "\twith this state loc:"
        + "\n\t\t"
        + myPlugin.getStateLocation()
        + "\n");

  }

  private IWorkbench getWorkbench() {
    return PlatformUI.getWorkbench();
  }

  /**
   * Saves a reference to the current selection in the workbench user interface.
   * 
   * @see org.eclipse.ui.IActionDelegate#selectionChanged(IAction, ISelection)
   */
  public void selectionChanged(IAction action, ISelection selection) {
    this.mySelection =
      (org.eclipse.jface.viewers.IStructuredSelection) selection;

  }

  /* non-Javadoc
   * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
   */
  public void setActivePart(IAction action, IWorkbenchPart targetPart) {
  }

  /**
   * Write trace statements.  
   * System.out.println used for simplicity.
   */
  private void traceMsg(String msg) {
    if (IDialogsIDs.TRACE_ENABLED | traceEnabled)
      System.out.println(msg);
  }

}