package com.ibm.lab.soln.resourceview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import com.ibm.lab.soln.jface.JFaceComponent;

/**
 * @see ViewPart
 */
//Edu-Sol: 00  - Create by subclassing ViewPart 
public class ResourceView extends ViewPart implements ISelectionListener {

	private JFaceComponent jcomp;

	private Action action1;
	private Action action2;
	private Action doubleClickAction;

	// field to reference filter in action logic
	private ResourceFilter filter = new ResourceFilter();

	/**
	 */
	public ResourceView() {
	}

	/**
		 * @author PatMc
		 *
		 * To change the template for this generated type comment go to
		 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
		 */
	public class ResourceSorter extends ViewerSorter {
		int dotted_cat = 0;
		int container_cat = 1;
		int file_cat = 2;

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ViewerSorter#category(java.lang.Object)
		 */
		public int category(Object element) {
			// Category defined by type (Container/File/File starting with a .)
			if (element instanceof IContainer)
				return container_cat;
			else {
				IFile file = (IFile) element;
				if (file.getName().startsWith("."))
					return dotted_cat;
				else
					return file_cat;
			}
		}

	}

	// Filter for viewer
	public class ResourceFilter extends ViewerFilter {

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public boolean select(Viewer viewer, Object parentElement, Object element) {
			// Return true for all but dotted files (starts with a .)
			if (element instanceof IFile) {
				IFile file = (IFile) element;
				if (file.getName().startsWith("."))
					return false;
				else
					return true;
			} else
				return true;
		}
	}

	/**
	 * @see ViewPart#createPartControl
	 */
	public void createPartControl(Composite parent) {
		// Edu-Sol: 01  - Create JFace Viewer (JFaceComponent)
		//		Edu-Sol: 05a - JFace component passes either a composite or table to the viewer
		jcomp = createJFaceComponent(parent);

		//		Edu-Sol: 06a - Viewer configured with a content and label provider
		jcomp.configureViewer();

		//		Edu-Sol: 07a - Input to viewer is defined
		jcomp.setInput(ViewPlugin.getWorkspace().getRoot());

		// Edu-Sol: 02a - Listen to viewer selection
		//		jcomp.addSelectionChangedListener(this);
		processViewerSelection();

		//	Edu-Sol: 03  - Share Viewer Selection with other workbench parts
		getViewSite().setSelectionProvider(jcomp.getViewer());

		//	Edu-Sol: 04a - Listen to selection in other workbench parts
		getSite().getPage().addSelectionListener(
			"org.eclipse.ui.views.ResourceNavigator",
			this);

		// Menu/Actions logic
		makeActions(jcomp.getViewer());
		hookContextMenu(jcomp.getViewer());
		hookDoubleClickAction(jcomp.getViewer());
		contributeToActionBars();

		// Add sorter to viewer
		jcomp.getViewer().setSorter(new ResourceSorter());

		//******************************************************
		//******************************************************

	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
			System.out.println("View heard outside selection " + selection);

			//	Edu-Sol: 04b - React to selection in other workbench parts
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.getFirstElement() instanceof IContainer)
				jcomp.setInput((IContainer) ssel.getFirstElement());
			else
				jcomp.setInput(ViewPlugin.getWorkspace().getRoot());
		}

	/**
	 * Adds a selection changed listener to the viewer and implements logic to show
	 * current selection location in the workbench status bar area.
	 */
	private void processViewerSelection() {
		jcomp.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				System.out.println(">View hears selection" + event.getSelection());
				IStructuredSelection ssel = (IStructuredSelection) event.getSelection();

				//Get common Workbench status bar
				IStatusLineManager status =
					getViewSite().getActionBars().getStatusLineManager();

				// Push IResource location to status bar
				if ((ssel != null) && (ssel.getFirstElement() instanceof IResource)) {
					IResource res = (IResource) ssel.getFirstElement();
					status.setMessage(res.getLocation().toString());
				} else {
					status.setMessage(null);
				}
				status.update(false);
			}

		});
	}

	
	/**
	 * This logic creates actions that open dialogs to show when the
	 * action was invoked. The viewer passed sent along to the dialog method 
	 * to get the shell for the dialogs that are opened.
	 * 
	 * The viewer is also used to support the dynamic add/remove of the filter.
	 * 
	 * @param viewer
	 */
	private void makeActions(final StructuredViewer viewer) {
		action1 = new Action() {
			public void run() {
				showMessage(viewer, "Action 1 executed");
			}
		};
		action1.setText("Action 1");
		action1.setToolTipText("Action 1 tooltip");
		action1.setImageDescriptor(
			PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
				ISharedImages.IMG_OBJS_INFO_TSK));

		action2 = new Action("Action 2", IAction.AS_RADIO_BUTTON) {
			public void run() {
				if (this.isChecked())
					//	Add filter to viewer
					viewer.addFilter(filter);
				else
					//	Remove filter to viewer
					viewer.removeFilter(filter);
			}
		};
		action2.setToolTipText("Action 2 tooltip");
		action2.setChecked(false);
		action2.setImageDescriptor(
			PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
				ISharedImages.IMG_OBJS_TASK_TSK));

		doubleClickAction = new Action() {
			public void run() {
				ISelection selection = viewer.getSelection();
				Object obj = ((IStructuredSelection) selection).getFirstElement();
				showMessage(viewer, "Double-click detected on " + obj.toString());
			}
		};
	}

	/**
	 * Called to open a dialog in response to some action request.
	 * 
	 * @param viewer
	 * @param message
	 */
	private void showMessage(StructuredViewer viewer, String message) {
		MessageDialog.openInformation(
			viewer.getControl().getShell(),
			"Sample View",
			message);
	}

	/**
	 * Creates a context menu that is associated to a viewer.  Dynamically
	 * adds content to the menu prior to it being shown to the user.
	 * @param viewer
	 */
	private void hookContextMenu(StructuredViewer viewer) {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);

		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {

				manager.add(action1);
				manager.add(action2);
				
				// Other plug-ins can contribute there actions here ("additions")
				manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
			}
		});

		Menu menu = menuMgr.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, viewer);
	}

	/**
	 * Adds actions to the view part menu and tool bar managers.
	 */
	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();

		IMenuManager manager1 = bars.getMenuManager();
		manager1.add(action1);
		manager1.add(new Separator());
		manager1.add(action2);

		IToolBarManager manager = bars.getToolBarManager();
		manager.add(action1);
		manager.add(action2);
	}

	/**
	 * Double click processing for a viewer selection.
	 * @param viewer
	 */
	private void hookDoubleClickAction(StructuredViewer viewer) {
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				doubleClickAction.run();
			}
		});
	}

	/**
	 * Utility method with a hardcode value controlling which processing is performed.
	 * Option 1 is to create a viewer which creates a simple single column table.
	 * Option 2 is to create a multi-column table and use this when creating the viewer.
	 * 
	 *  
	 * 
	 * @param composite parent for the viewer to be created
	 * @return a <code>JFaceComponent</code>
	 */
	
	private JFaceComponent createJFaceComponent(Composite composite) {
		// Hardcoded Option Choice  
		String opt = new String("2");

		//	Option 1: use the component as-is (table created by viewer)
		if (opt.equals("1")) {
			JFaceComponent jfaceComp = new JFaceComponent(composite);
			return jfaceComp;

			//	Option 2: create a table then the component
		} else {
			Table table = createTableControl(composite);
			JFaceComponent jfaceComp = new JFaceComponent(table);
			return jfaceComp;
		}
	}

	/**
	 * Creates a two column table with headers and appropriate column weight
	 * 
	 * @param parent Control to be the <code>Table</code> control parent 
	 * @return <code>Table</code> control
	 */

	private Table createTableControl(Composite parent) {
		Table table = 	new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI | SWT.FULL_SELECTION);
		table.setLinesVisible(true);

		TableLayout layout = new TableLayout();
		table.setLayout(layout);

		table.setHeaderVisible(true);
		String[] STD_HEADINGS = { "Resource Name", "Resource Data" };

		layout.addColumnData(new ColumnWeightData(5, 40, true));
		TableColumn tc0 = new TableColumn(table, SWT.NONE);
		tc0.setText(STD_HEADINGS[0]);
		tc0.setAlignment(SWT.LEFT);
		tc0.setResizable(true);

		layout.addColumnData(new ColumnWeightData(10, true));
		TableColumn tc1 = new TableColumn(table, SWT.NONE);
		tc1.setText(STD_HEADINGS[1]);
		tc1.setAlignment(SWT.LEFT);
		tc1.setResizable(true);

		return table;
	}

	/**
	 * @see ViewPart#setFocus
	 */
	public void setFocus() {
	}

}
