/*
 * "The Java Developer's Guide to Eclipse"
 * 
 * (C) Copyright International Business Machines Corporation, 2003.
 * All Rights Reserved.
 * 
 * Code or samples provided herein are provided without warranty of any kind.
 */
package com.ibm.lab.soln.jface;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/**
 * @author PatMc
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class MembersDialog extends Dialog {

	private IContainer focusFolder;

	/**
	 * @param parentShell
	 */
	public MembersDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * @param shell
	 * @param readmeFolder
	 */
	// Edu-Sol: 02  - Save reference to input folder 
	public MembersDialog(Shell shell, IContainer readmeFolder) {
		this(shell);
		focusFolder = readmeFolder;
	}

	/**
	 * Creates a customized user interface. The JFaceComponent is used 
	 * to provide the user interface in the dialog. 
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(Composite)
	 */
	// Edu-Sol: 03  - Create dialog UI using JFace Component
	protected Control createDialogArea(Composite parent) {
		// Define title
		getShell().setText("JFace Component Dialog");

		// Create layouts required for this dialog
		FillLayout fillLayout = new FillLayout();
		fillLayout.type = SWT.VERTICAL;

		RowLayout rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.justify = true;

		//	Get customized composite from parent and create composite layers
		Composite dialogArea = (Composite) super.createDialogArea(parent);
		dialogArea.setLayout(fillLayout);

		Composite txtArea = new Composite(dialogArea, SWT.BORDER);
		txtArea.setLayout(fillLayout);

		Composite viewerArea = new Composite(dialogArea, SWT.BORDER);
		viewerArea.setLayout(fillLayout);

		// Define labels for display of input and later viewer selection
		Label input = new Label(txtArea, SWT.NONE);
		input.setText(focusFolder.toString());

		final Label selected = new Label(txtArea, SWT.NONE);
		selected.setText("");

		// Edu: Customize Dialog UI - Add JFace Viewer Here

		addJFaceComponent(viewerArea, selected);

		return dialogArea;
	}

	/**
	 * @param viewerArea - composite where viewer should be added
	 * @param selected - label that can be used to provide viewer selection feedback
	 */
	private void addJFaceComponent(Composite viewerArea, final Label selected) {
		//	Edu-Sol: 05a - JFace component passes either a composite or table to the viewer
		JFaceComponent jcomp = createJFaceComponent(viewerArea);
		
		//		Edu-Sol: 06a - Viewer configured with a content and label provider
		jcomp.configureViewer();
		
		//		Edu-Sol: 07a - Input to viewer is defined
		jcomp.setInput(focusFolder);

		// Edu-Sol: 04a - Add viewer selection listener
		jcomp.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				// Edu-Sol: 04b - Send selection to label
				System.out.println(">Dialog hears selection" + event.getSelection());
				IStructuredSelection ssel = (IStructuredSelection) event.getSelection();
				selected.setText("");
				if ((ssel != null) && (ssel.getFirstElement() instanceof IResource)) {
					IResource res = (IResource) ssel.getFirstElement();
					selected.setText(res.getName());
				}
			}
		});
	}

	/**
	 * Demonstrates use of viewer alone or viewer with custom table control
	 * @param composite
	 */
	private JFaceComponent createJFaceComponent(Composite composite) {
		// Hardcoded Option Choice  
		String opt = new String("1");

		//	Option 1: use the component as-is (table created by viewer)
		if (opt.equals("1")) {
			JFaceComponent jfaceComp = new JFaceComponent(composite);
			return jfaceComp;

			//	Option 2: create a table then the component
		} else {
			Table table =
				new Table(
					composite,
					SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);

			TableLayout layout = new TableLayout();
			table.setLayout(layout);

			JFaceComponent jfaceComp = new JFaceComponent(table);
			return jfaceComp;
		}
	}

}
